/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) 2020 Marvell International Ltd.
 *
 * Configuration and status register (CSR) type definitions for
 * Octeon sli.
 */

#ifndef __CVMX_SLI_DEFS_H__
#define __CVMX_SLI_DEFS_H__

#define CVMX_SLI_BIST_STATUS CVMX_SLI_BIST_STATUS_FUNC()
static inline u64 CVMX_SLI_BIST_STATUS_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000580ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000000580ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000028580ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000028580ull;
	}
	return 0x0000000000028580ull;
}

#define CVMX_SLI_CIU_INT_ENB (0x00011F0000027110ull)
#define CVMX_SLI_CIU_INT_SUM (0x00011F0000027100ull)
static inline u64 CVMX_SLI_CTL_PORTX(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000050ull + (offset) * 16;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000000000010050ull + (offset) * 16;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000050ull + (offset) * 16;

	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00000000000006E0ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00000000000286E0ull + (offset) * 16;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00000000000286E0ull + (offset) * 16;
	}
	return 0x00000000000286E0ull + (offset) * 16;
}

#define CVMX_SLI_CTL_STATUS CVMX_SLI_CTL_STATUS_FUNC()
static inline u64 CVMX_SLI_CTL_STATUS_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000570ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000000570ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000028570ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000028570ull;
	}
	return 0x0000000000028570ull;
}

#define CVMX_SLI_DATA_OUT_CNT CVMX_SLI_DATA_OUT_CNT_FUNC()
static inline u64 CVMX_SLI_DATA_OUT_CNT_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00000000000005F0ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00000000000005F0ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00000000000285F0ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00000000000285F0ull;
	}
	return 0x00000000000285F0ull;
}

#define CVMX_SLI_DBG_DATA   (0x0000000000000310ull)
#define CVMX_SLI_DBG_SELECT (0x0000000000000300ull)
static inline u64 CVMX_SLI_DMAX_CNT(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000400ull + (offset) * 16;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000000400ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000028400ull + (offset) * 16;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000028400ull + (offset) * 16;
	}
	return 0x0000000000028400ull + (offset) * 16;
}

static inline u64 CVMX_SLI_DMAX_INT_LEVEL(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00000000000003E0ull + (offset) * 16;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00000000000003E0ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00000000000283E0ull + (offset) * 16;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00000000000283E0ull + (offset) * 16;
	}
	return 0x00000000000283E0ull + (offset) * 16;
}

static inline u64 CVMX_SLI_DMAX_TIM(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000420ull + (offset) * 16;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000000420ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000028420ull + (offset) * 16;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000028420ull + (offset) * 16;
	}
	return 0x0000000000028420ull + (offset) * 16;
}

#define CVMX_SLI_INT_ENB_CIU	       (0x0000000000003CD0ull)
#define CVMX_SLI_INT_ENB_PORTX(offset) (0x0000000000000340ull + ((offset) & 3) * 16)
#define CVMX_SLI_INT_SUM	       (0x0000000000000330ull)
#define CVMX_SLI_LAST_WIN_RDATA0       (0x0000000000000600ull)
#define CVMX_SLI_LAST_WIN_RDATA1       (0x0000000000000610ull)
#define CVMX_SLI_LAST_WIN_RDATA2       (0x00000000000006C0ull)
#define CVMX_SLI_LAST_WIN_RDATA3       (0x00000000000006D0ull)
#define CVMX_SLI_MACX_PFX_DMA_VF_INT(offset, block_id)                                             \
	(0x0000000000027280ull + (((offset) & 1) + ((block_id) & 3) * 0x2ull) * 16)
#define CVMX_SLI_MACX_PFX_DMA_VF_INT_ENB(offset, block_id)                                         \
	(0x0000000000027500ull + (((offset) & 1) + ((block_id) & 3) * 0x2ull) * 16)
#define CVMX_SLI_MACX_PFX_FLR_VF_INT(offset, block_id)                                             \
	(0x0000000000027400ull + (((offset) & 1) + ((block_id) & 3) * 0x2ull) * 16)
#define CVMX_SLI_MACX_PFX_INT_ENB(offset, block_id)                                                \
	(0x0000000000027080ull + (((offset) & 1) + ((block_id) & 3) * 0x2ull) * 16)
#define CVMX_SLI_MACX_PFX_INT_SUM(offset, block_id)                                                \
	(0x0000000000027000ull + (((offset) & 1) + ((block_id) & 3) * 0x2ull) * 16)
#define CVMX_SLI_MACX_PFX_MBOX_INT(offset, block_id)                                               \
	(0x0000000000027380ull + (((offset) & 1) + ((block_id) & 3) * 0x2ull) * 16)
#define CVMX_SLI_MACX_PFX_PKT_VF_INT(offset, block_id)                                             \
	(0x0000000000027300ull + (((offset) & 1) + ((block_id) & 3) * 0x2ull) * 16)
#define CVMX_SLI_MACX_PFX_PKT_VF_INT_ENB(offset, block_id)                                         \
	(0x0000000000027580ull + (((offset) & 1) + ((block_id) & 3) * 0x2ull) * 16)
#define CVMX_SLI_MACX_PFX_PP_VF_INT(offset, block_id)                                              \
	(0x0000000000027200ull + (((offset) & 1) + ((block_id) & 3) * 0x2ull) * 16)
#define CVMX_SLI_MACX_PFX_PP_VF_INT_ENB(offset, block_id)                                          \
	(0x0000000000027480ull + (((offset) & 1) + ((block_id) & 3) * 0x2ull) * 16)
#define CVMX_SLI_MAC_CREDIT_CNT CVMX_SLI_MAC_CREDIT_CNT_FUNC()
static inline u64 CVMX_SLI_MAC_CREDIT_CNT_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000003D70ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000003D70ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000023D70ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000023D70ull;
	}
	return 0x0000000000023D70ull;
}

#define CVMX_SLI_MAC_CREDIT_CNT2 CVMX_SLI_MAC_CREDIT_CNT2_FUNC()
static inline u64 CVMX_SLI_MAC_CREDIT_CNT2_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
		return 0x0000000000013E10ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000003E10ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000023E10ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000023E10ull;
	}
	return 0x0000000000023E10ull;
}

#define CVMX_SLI_MAC_NUMBER CVMX_SLI_MAC_NUMBER_FUNC()
static inline u64 CVMX_SLI_MAC_NUMBER_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000003E00ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000003E00ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000020050ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000020050ull;
	}
	return 0x0000000000020050ull;
}

#define CVMX_SLI_MEM_ACCESS_CTL CVMX_SLI_MEM_ACCESS_CTL_FUNC()
static inline u64 CVMX_SLI_MEM_ACCESS_CTL_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00000000000002F0ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00000000000002F0ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00000000000282F0ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00000000000282F0ull;
	}
	return 0x00000000000282F0ull;
}

static inline u64 CVMX_SLI_MEM_ACCESS_SUBIDX(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00000000000000E0ull + (offset) * 16 - 16 * 12;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00000000000000E0ull + (offset) * 16 - 16 * 12;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00000000000280E0ull + (offset) * 16 - 16 * 12;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00000000000280E0ull + (offset) * 16 - 16 * 12;
	}
	return 0x00000000000280E0ull + (offset) * 16 - 16 * 12;
}

#define CVMX_SLI_MEM_CTL CVMX_SLI_MEM_CTL_FUNC()
static inline u64 CVMX_SLI_MEM_CTL_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00000000000005E0ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00000000000285E0ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00000000000285E0ull;
	}
	return 0x00000000000285E0ull;
}

#define CVMX_SLI_MEM_INT_SUM CVMX_SLI_MEM_INT_SUM_FUNC()
static inline u64 CVMX_SLI_MEM_INT_SUM_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00000000000005D0ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00000000000285D0ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00000000000285D0ull;
	}
	return 0x00000000000285D0ull;
}

static inline u64 CVMX_SLI_MSIXX_TABLE_ADDR(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000006000ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000000000ull + (offset) * 16;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000000ull + (offset) * 16;
	}
	return 0x0000000000000000ull + (offset) * 16;
}

static inline u64 CVMX_SLI_MSIXX_TABLE_DATA(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000006008ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000000008ull + (offset) * 16;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000008ull + (offset) * 16;
	}
	return 0x0000000000000008ull + (offset) * 16;
}

#define CVMX_SLI_MSIX_MACX_PF_TABLE_ADDR(offset) (0x0000000000007C00ull + ((offset) & 3) * 16)
#define CVMX_SLI_MSIX_MACX_PF_TABLE_DATA(offset) (0x0000000000007C08ull + ((offset) & 3) * 16)
#define CVMX_SLI_MSIX_PBA0			 CVMX_SLI_MSIX_PBA0_FUNC()
static inline u64 CVMX_SLI_MSIX_PBA0_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000007000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000001000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000001000ull;
	}
	return 0x0000000000001000ull;
}

#define CVMX_SLI_MSIX_PBA1 CVMX_SLI_MSIX_PBA1_FUNC()
static inline u64 CVMX_SLI_MSIX_PBA1_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000007010ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000001008ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000001008ull;
	}
	return 0x0000000000001008ull;
}

#define CVMX_SLI_MSI_ENB0 (0x0000000000003C50ull)
#define CVMX_SLI_MSI_ENB1 (0x0000000000003C60ull)
#define CVMX_SLI_MSI_ENB2 (0x0000000000003C70ull)
#define CVMX_SLI_MSI_ENB3 (0x0000000000003C80ull)
#define CVMX_SLI_MSI_RCV0 CVMX_SLI_MSI_RCV0_FUNC()
static inline u64 CVMX_SLI_MSI_RCV0_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000003C10ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000003C10ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000023C10ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000023C10ull;
	}
	return 0x0000000000023C10ull;
}

#define CVMX_SLI_MSI_RCV1 CVMX_SLI_MSI_RCV1_FUNC()
static inline u64 CVMX_SLI_MSI_RCV1_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000003C20ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000003C20ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000023C20ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000023C20ull;
	}
	return 0x0000000000023C20ull;
}

#define CVMX_SLI_MSI_RCV2 CVMX_SLI_MSI_RCV2_FUNC()
static inline u64 CVMX_SLI_MSI_RCV2_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000003C30ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000003C30ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000023C30ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000023C30ull;
	}
	return 0x0000000000023C30ull;
}

#define CVMX_SLI_MSI_RCV3 CVMX_SLI_MSI_RCV3_FUNC()
static inline u64 CVMX_SLI_MSI_RCV3_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000003C40ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000003C40ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000023C40ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000023C40ull;
	}
	return 0x0000000000023C40ull;
}

#define CVMX_SLI_MSI_RD_MAP CVMX_SLI_MSI_RD_MAP_FUNC()
static inline u64 CVMX_SLI_MSI_RD_MAP_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000003CA0ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000003CA0ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000023CA0ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000023CA0ull;
	}
	return 0x0000000000023CA0ull;
}

#define CVMX_SLI_MSI_W1C_ENB0 (0x0000000000003CF0ull)
#define CVMX_SLI_MSI_W1C_ENB1 (0x0000000000003D00ull)
#define CVMX_SLI_MSI_W1C_ENB2 (0x0000000000003D10ull)
#define CVMX_SLI_MSI_W1C_ENB3 (0x0000000000003D20ull)
#define CVMX_SLI_MSI_W1S_ENB0 (0x0000000000003D30ull)
#define CVMX_SLI_MSI_W1S_ENB1 (0x0000000000003D40ull)
#define CVMX_SLI_MSI_W1S_ENB2 (0x0000000000003D50ull)
#define CVMX_SLI_MSI_W1S_ENB3 (0x0000000000003D60ull)
#define CVMX_SLI_MSI_WR_MAP   CVMX_SLI_MSI_WR_MAP_FUNC()
static inline u64 CVMX_SLI_MSI_WR_MAP_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000003C90ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000003C90ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000023C90ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000023C90ull;
	}
	return 0x0000000000023C90ull;
}

#define CVMX_SLI_NQM_RSP_ERR_SND_DBG (0x00011F0000028800ull)
#define CVMX_SLI_PCIE_MSI_RCV	     CVMX_SLI_PCIE_MSI_RCV_FUNC()
static inline u64 CVMX_SLI_PCIE_MSI_RCV_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000003CB0ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000003CB0ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000023CB0ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000023CB0ull;
	}
	return 0x0000000000023CB0ull;
}

#define CVMX_SLI_PCIE_MSI_RCV_B1 CVMX_SLI_PCIE_MSI_RCV_B1_FUNC()
static inline u64 CVMX_SLI_PCIE_MSI_RCV_B1_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000650ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000000650ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000028650ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000028650ull;
	}
	return 0x0000000000028650ull;
}

#define CVMX_SLI_PCIE_MSI_RCV_B2 CVMX_SLI_PCIE_MSI_RCV_B2_FUNC()
static inline u64 CVMX_SLI_PCIE_MSI_RCV_B2_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000660ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000000660ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000028660ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000028660ull;
	}
	return 0x0000000000028660ull;
}

#define CVMX_SLI_PCIE_MSI_RCV_B3 CVMX_SLI_PCIE_MSI_RCV_B3_FUNC()
static inline u64 CVMX_SLI_PCIE_MSI_RCV_B3_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000670ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000000670ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000028670ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000028670ull;
	}
	return 0x0000000000028670ull;
}

static inline u64 CVMX_SLI_PKTX_CNTS(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000002400ull + (offset) * 16;

	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000002400ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00000000000100B0ull + (offset) * 0x20000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00000000000100B0ull + (offset) * 0x20000ull;
	}
	return 0x00000000000100B0ull + (offset) * 0x20000ull;
}

#define CVMX_SLI_PKTX_ERROR_INFO(offset) (0x00000000000100C0ull + ((offset) & 63) * 0x20000ull)
static inline u64 CVMX_SLI_PKTX_INPUT_CONTROL(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000004000ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000010000ull + (offset) * 0x20000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000010000ull + (offset) * 0x20000ull;
	}
	return 0x0000000000010000ull + (offset) * 0x20000ull;
}

static inline u64 CVMX_SLI_PKTX_INSTR_BADDR(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000002800ull + (offset) * 16;

	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000002800ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000010010ull + (offset) * 0x20000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000010010ull + (offset) * 0x20000ull;
	}
	return 0x0000000000010010ull + (offset) * 0x20000ull;
}

static inline u64 CVMX_SLI_PKTX_INSTR_BAOFF_DBELL(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000002C00ull + (offset) * 16;

	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000002C00ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000010020ull + (offset) * 0x20000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000010020ull + (offset) * 0x20000ull;
	}
	return 0x0000000000010020ull + (offset) * 0x20000ull;
}

static inline u64 CVMX_SLI_PKTX_INSTR_FIFO_RSIZE(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000003000ull + (offset) * 16;

	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000003000ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000010030ull + (offset) * 0x20000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000010030ull + (offset) * 0x20000ull;
	}
	return 0x0000000000010030ull + (offset) * 0x20000ull;
}

#define CVMX_SLI_PKTX_INSTR_HEADER(offset) (0x0000000000003400ull + ((offset) & 31) * 16)
static inline u64 CVMX_SLI_PKTX_INT_LEVELS(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000004400ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00000000000100A0ull + (offset) * 0x20000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00000000000100A0ull + (offset) * 0x20000ull;
	}
	return 0x00000000000100A0ull + (offset) * 0x20000ull;
}

#define CVMX_SLI_PKTX_IN_BP(offset)    (0x0000000000003800ull + ((offset) & 31) * 16)
#define CVMX_SLI_PKTX_MBOX_INT(offset) (0x0000000000010210ull + ((offset) & 63) * 0x20000ull)
static inline u64 CVMX_SLI_PKTX_OUTPUT_CONTROL(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000004800ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000010050ull + (offset) * 0x20000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000010050ull + (offset) * 0x20000ull;
	}
	return 0x0000000000010050ull + (offset) * 0x20000ull;
}

static inline u64 CVMX_SLI_PKTX_OUT_SIZE(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000C00ull + (offset) * 16;

	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000000C00ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000010060ull + (offset) * 0x20000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000010060ull + (offset) * 0x20000ull;
	}
	return 0x0000000000010060ull + (offset) * 0x20000ull;
}

#define CVMX_SLI_PKTX_PF_VF_MBOX_SIGX(offset, block_id)                                            \
	(0x0000000000010200ull + (((offset) & 1) + ((block_id) & 63) * 0x4000ull) * 8)
static inline u64 CVMX_SLI_PKTX_SLIST_BADDR(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000001400ull + (offset) * 16;

	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000001400ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000010070ull + (offset) * 0x20000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000010070ull + (offset) * 0x20000ull;
	}
	return 0x0000000000010070ull + (offset) * 0x20000ull;
}

static inline u64 CVMX_SLI_PKTX_SLIST_BAOFF_DBELL(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000001800ull + (offset) * 16;

	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000001800ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000010080ull + (offset) * 0x20000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000010080ull + (offset) * 0x20000ull;
	}
	return 0x0000000000010080ull + (offset) * 0x20000ull;
}

static inline u64 CVMX_SLI_PKTX_SLIST_FIFO_RSIZE(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000001C00ull + (offset) * 16;

	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000001C00ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000010090ull + (offset) * 0x20000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000010090ull + (offset) * 0x20000ull;
	}
	return 0x0000000000010090ull + (offset) * 0x20000ull;
}

#define CVMX_SLI_PKTX_VF_INT_SUM(offset) (0x00000000000100D0ull + ((offset) & 63) * 0x20000ull)
#define CVMX_SLI_PKTX_VF_SIG(offset)	 (0x0000000000004C00ull + ((offset) & 63) * 16)
#define CVMX_SLI_PKT_BIST_STATUS	 (0x0000000000029220ull)
#define CVMX_SLI_PKT_CNT_INT		 CVMX_SLI_PKT_CNT_INT_FUNC()
static inline u64 CVMX_SLI_PKT_CNT_INT_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000001130ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000001130ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000029130ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000029130ull;
	}
	return 0x0000000000029130ull;
}

#define CVMX_SLI_PKT_CNT_INT_ENB   (0x0000000000001150ull)
#define CVMX_SLI_PKT_CTL	   (0x0000000000001220ull)
#define CVMX_SLI_PKT_DATA_OUT_ES   (0x00000000000010B0ull)
#define CVMX_SLI_PKT_DATA_OUT_NS   (0x00000000000010A0ull)
#define CVMX_SLI_PKT_DATA_OUT_ROR  (0x0000000000001090ull)
#define CVMX_SLI_PKT_DPADDR	   (0x0000000000001080ull)
#define CVMX_SLI_PKT_GBL_CONTROL   (0x0000000000029210ull)
#define CVMX_SLI_PKT_INPUT_CONTROL (0x0000000000001170ull)
#define CVMX_SLI_PKT_INSTR_ENB	   (0x0000000000001000ull)
#define CVMX_SLI_PKT_INSTR_RD_SIZE (0x00000000000011A0ull)
#define CVMX_SLI_PKT_INSTR_SIZE	   (0x0000000000001020ull)
#define CVMX_SLI_PKT_INT	   CVMX_SLI_PKT_INT_FUNC()
static inline u64 CVMX_SLI_PKT_INT_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000001160ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000029160ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000029160ull;
	}
	return 0x0000000000029160ull;
}

#define CVMX_SLI_PKT_INT_LEVELS (0x0000000000001120ull)
#define CVMX_SLI_PKT_IN_BP	(0x0000000000001210ull)
static inline u64 CVMX_SLI_PKT_IN_DONEX_CNTS(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000002000ull + (offset) * 16;

	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000002000ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000010040ull + (offset) * 0x20000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000010040ull + (offset) * 0x20000ull;
	}
	return 0x0000000000010040ull + (offset) * 0x20000ull;
}

#define CVMX_SLI_PKT_IN_INSTR_COUNTS CVMX_SLI_PKT_IN_INSTR_COUNTS_FUNC()
static inline u64 CVMX_SLI_PKT_IN_INSTR_COUNTS_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000001200ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000001200ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000029200ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000029200ull;
	}
	return 0x0000000000029200ull;
}

#define CVMX_SLI_PKT_IN_INT CVMX_SLI_PKT_IN_INT_FUNC()
static inline u64 CVMX_SLI_PKT_IN_INT_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000001150ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000029150ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000029150ull;
	}
	return 0x0000000000029150ull;
}

#define CVMX_SLI_PKT_IN_JABBER	  (0x0000000000029170ull)
#define CVMX_SLI_PKT_IN_PCIE_PORT (0x00000000000011B0ull)
#define CVMX_SLI_PKT_IPTR	  (0x0000000000001070ull)
#define CVMX_SLI_PKT_MAC0_SIG0	  (0x0000000000001300ull)
#define CVMX_SLI_PKT_MAC0_SIG1	  (0x0000000000001310ull)
#define CVMX_SLI_PKT_MAC1_SIG0	  (0x0000000000001320ull)
#define CVMX_SLI_PKT_MAC1_SIG1	  (0x0000000000001330ull)
#define CVMX_SLI_PKT_MACX_PFX_RINFO(offset, block_id)                                              \
	(0x0000000000029030ull + (((offset) & 1) + ((block_id) & 3) * 0x2ull) * 16)
#define CVMX_SLI_PKT_MACX_RINFO(offset) (0x0000000000001030ull + ((offset) & 3) * 16)
#define CVMX_SLI_PKT_MEM_CTL		CVMX_SLI_PKT_MEM_CTL_FUNC()
static inline u64 CVMX_SLI_PKT_MEM_CTL_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000001120ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000029120ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000029120ull;
	}
	return 0x0000000000029120ull;
}

#define CVMX_SLI_PKT_OUTPUT_WMARK CVMX_SLI_PKT_OUTPUT_WMARK_FUNC()
static inline u64 CVMX_SLI_PKT_OUTPUT_WMARK_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000001180ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000001180ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000029180ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000029180ull;
	}
	return 0x0000000000029180ull;
}

#define CVMX_SLI_PKT_OUT_BMODE	    (0x00000000000010D0ull)
#define CVMX_SLI_PKT_OUT_BP_EN	    (0x0000000000001240ull)
#define CVMX_SLI_PKT_OUT_BP_EN2_W1C (0x0000000000029290ull)
#define CVMX_SLI_PKT_OUT_BP_EN2_W1S (0x0000000000029270ull)
#define CVMX_SLI_PKT_OUT_BP_EN_W1C  (0x0000000000029280ull)
#define CVMX_SLI_PKT_OUT_BP_EN_W1S  (0x0000000000029260ull)
#define CVMX_SLI_PKT_OUT_ENB	    (0x0000000000001010ull)
#define CVMX_SLI_PKT_PCIE_PORT	    (0x00000000000010E0ull)
#define CVMX_SLI_PKT_PKIND_VALID    (0x0000000000029190ull)
#define CVMX_SLI_PKT_PORT_IN_RST    (0x00000000000011F0ull)
#define CVMX_SLI_PKT_RING_RST	    CVMX_SLI_PKT_RING_RST_FUNC()
static inline u64 CVMX_SLI_PKT_RING_RST_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00000000000011E0ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00000000000291E0ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00000000000291E0ull;
	}
	return 0x00000000000291E0ull;
}

#define CVMX_SLI_PKT_SLIST_ES  (0x0000000000001050ull)
#define CVMX_SLI_PKT_SLIST_NS  (0x0000000000001040ull)
#define CVMX_SLI_PKT_SLIST_ROR (0x0000000000001030ull)
#define CVMX_SLI_PKT_TIME_INT  CVMX_SLI_PKT_TIME_INT_FUNC()
static inline u64 CVMX_SLI_PKT_TIME_INT_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000001140ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000001140ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000029140ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000029140ull;
	}
	return 0x0000000000029140ull;
}

#define CVMX_SLI_PKT_TIME_INT_ENB    (0x0000000000001160ull)
#define CVMX_SLI_PORTX_PKIND(offset) (0x0000000000000800ull + ((offset) & 31) * 16)
#define CVMX_SLI_PP_PKT_CSR_CONTROL  (0x00011F00000282D0ull)
#define CVMX_SLI_S2C_END_MERGE	     CVMX_SLI_S2C_END_MERGE_FUNC()
static inline u64 CVMX_SLI_S2C_END_MERGE_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00011F0000015000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00011F0000025000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00011F0000025000ull;
	}
	return 0x00011F0000025000ull;
}

static inline u64 CVMX_SLI_S2M_PORTX_CTL(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000003D80ull + (offset) * 16;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
		return 0x0000000000003D80ull + (offset) * 16;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000000000013D80ull + (offset) * 16;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000003D80ull + (offset) * 16;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000023D80ull + (offset) * 16;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000023D80ull + (offset) * 16;
	}
	return 0x0000000000023D80ull + (offset) * 16;
}

#define CVMX_SLI_SCRATCH_1 CVMX_SLI_SCRATCH_1_FUNC()
static inline u64 CVMX_SLI_SCRATCH_1_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00000000000003C0ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00000000000003C0ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00000000000283C0ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00000000000283C0ull;
	}
	return 0x00000000000283C0ull;
}

#define CVMX_SLI_SCRATCH_2 CVMX_SLI_SCRATCH_2_FUNC()
static inline u64 CVMX_SLI_SCRATCH_2_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00000000000003D0ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00000000000003D0ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00000000000283D0ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00000000000283D0ull;
	}
	return 0x00000000000283D0ull;
}

#define CVMX_SLI_STATE1 CVMX_SLI_STATE1_FUNC()
static inline u64 CVMX_SLI_STATE1_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000620ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000000620ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000028620ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000028620ull;
	}
	return 0x0000000000028620ull;
}

#define CVMX_SLI_STATE2 CVMX_SLI_STATE2_FUNC()
static inline u64 CVMX_SLI_STATE2_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000630ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000000630ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000028630ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000028630ull;
	}
	return 0x0000000000028630ull;
}

#define CVMX_SLI_STATE3 CVMX_SLI_STATE3_FUNC()
static inline u64 CVMX_SLI_STATE3_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000640ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000000640ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000028640ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000028640ull;
	}
	return 0x0000000000028640ull;
}

#define CVMX_SLI_TX_PIPE    (0x0000000000001230ull)
#define CVMX_SLI_WINDOW_CTL CVMX_SLI_WINDOW_CTL_FUNC()
static inline u64 CVMX_SLI_WINDOW_CTL_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00000000000002E0ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00000000000002E0ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00000000000282E0ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00000000000282E0ull;
	}
	return 0x00000000000282E0ull;
}

#define CVMX_SLI_WIN_RD_ADDR CVMX_SLI_WIN_RD_ADDR_FUNC()
static inline u64 CVMX_SLI_WIN_RD_ADDR_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000010ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000000010ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000020010ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000020010ull;
	}
	return 0x0000000000020010ull;
}

#define CVMX_SLI_WIN_RD_DATA CVMX_SLI_WIN_RD_DATA_FUNC()
static inline u64 CVMX_SLI_WIN_RD_DATA_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000040ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000000040ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000020040ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000020040ull;
	}
	return 0x0000000000020040ull;
}

#define CVMX_SLI_WIN_WR_ADDR CVMX_SLI_WIN_WR_ADDR_FUNC()
static inline u64 CVMX_SLI_WIN_WR_ADDR_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000020000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000020000ull;
	}
	return 0x0000000000020000ull;
}

#define CVMX_SLI_WIN_WR_DATA CVMX_SLI_WIN_WR_DATA_FUNC()
static inline u64 CVMX_SLI_WIN_WR_DATA_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000020ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000000020ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000020020ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000020020ull;
	}
	return 0x0000000000020020ull;
}

#define CVMX_SLI_WIN_WR_MASK CVMX_SLI_WIN_WR_MASK_FUNC()
static inline u64 CVMX_SLI_WIN_WR_MASK_FUNC(void)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000030ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000000000000030ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000000000020030ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000000000020030ull;
	}
	return 0x0000000000020030ull;
}

/**
 * cvmx_sli_bist_status
 *
 * This register contains results from BIST runs of MAC's memories: 0 = pass (or BIST in
 * progress/never run), 1 = fail.
 */
union cvmx_sli_bist_status {
	u64 u64;
	struct cvmx_sli_bist_status_s {
		u64 reserved_32_63 : 32;
		u64 ncb_req : 1;
		u64 n2p0_c : 1;
		u64 n2p0_o : 1;
		u64 n2p1_c : 1;
		u64 n2p1_o : 1;
		u64 cpl_p0 : 1;
		u64 cpl_p1 : 1;
		u64 reserved_19_24 : 6;
		u64 p2n0_c0 : 1;
		u64 p2n0_c1 : 1;
		u64 p2n0_n : 1;
		u64 p2n0_p0 : 1;
		u64 p2n0_p1 : 1;
		u64 p2n1_c0 : 1;
		u64 p2n1_c1 : 1;
		u64 p2n1_n : 1;
		u64 p2n1_p0 : 1;
		u64 p2n1_p1 : 1;
		u64 reserved_6_8 : 3;
		u64 dsi1_1 : 1;
		u64 dsi1_0 : 1;
		u64 dsi0_1 : 1;
		u64 dsi0_0 : 1;
		u64 msi : 1;
		u64 ncb_cmd : 1;
	} s;
	struct cvmx_sli_bist_status_cn61xx {
		u64 reserved_31_63 : 33;
		u64 n2p0_c : 1;
		u64 n2p0_o : 1;
		u64 reserved_27_28 : 2;
		u64 cpl_p0 : 1;
		u64 cpl_p1 : 1;
		u64 reserved_19_24 : 6;
		u64 p2n0_c0 : 1;
		u64 p2n0_c1 : 1;
		u64 p2n0_n : 1;
		u64 p2n0_p0 : 1;
		u64 p2n0_p1 : 1;
		u64 p2n1_c0 : 1;
		u64 p2n1_c1 : 1;
		u64 p2n1_n : 1;
		u64 p2n1_p0 : 1;
		u64 p2n1_p1 : 1;
		u64 reserved_6_8 : 3;
		u64 dsi1_1 : 1;
		u64 dsi1_0 : 1;
		u64 dsi0_1 : 1;
		u64 dsi0_0 : 1;
		u64 msi : 1;
		u64 ncb_cmd : 1;
	} cn61xx;
	struct cvmx_sli_bist_status_cn63xx {
		u64 reserved_31_63 : 33;
		u64 n2p0_c : 1;
		u64 n2p0_o : 1;
		u64 n2p1_c : 1;
		u64 n2p1_o : 1;
		u64 cpl_p0 : 1;
		u64 cpl_p1 : 1;
		u64 reserved_19_24 : 6;
		u64 p2n0_c0 : 1;
		u64 p2n0_c1 : 1;
		u64 p2n0_n : 1;
		u64 p2n0_p0 : 1;
		u64 p2n0_p1 : 1;
		u64 p2n1_c0 : 1;
		u64 p2n1_c1 : 1;
		u64 p2n1_n : 1;
		u64 p2n1_p0 : 1;
		u64 p2n1_p1 : 1;
		u64 reserved_6_8 : 3;
		u64 dsi1_1 : 1;
		u64 dsi1_0 : 1;
		u64 dsi0_1 : 1;
		u64 dsi0_0 : 1;
		u64 msi : 1;
		u64 ncb_cmd : 1;
	} cn63xx;
	struct cvmx_sli_bist_status_cn63xx cn63xxp1;
	struct cvmx_sli_bist_status_cn61xx cn66xx;
	struct cvmx_sli_bist_status_s cn68xx;
	struct cvmx_sli_bist_status_s cn68xxp1;
	struct cvmx_sli_bist_status_cn70xx {
		u64 reserved_31_63 : 33;
		u64 n2p0_c : 1;
		u64 n2p0_o : 1;
		u64 reserved_27_28 : 2;
		u64 cpl_p0 : 1;
		u64 cpl_p1 : 1;
		u64 reserved_19_24 : 6;
		u64 p2n0_c0 : 1;
		u64 reserved_17_17 : 1;
		u64 p2n0_n : 1;
		u64 p2n0_p0 : 1;
		u64 reserved_14_14 : 1;
		u64 p2n1_c0 : 1;
		u64 reserved_12_12 : 1;
		u64 p2n1_n : 1;
		u64 p2n1_p0 : 1;
		u64 reserved_6_9 : 4;
		u64 dsi1_1 : 1;
		u64 dsi1_0 : 1;
		u64 dsi0_1 : 1;
		u64 dsi0_0 : 1;
		u64 msi : 1;
		u64 ncb_cmd : 1;
	} cn70xx;
	struct cvmx_sli_bist_status_cn70xx cn70xxp1;
	struct cvmx_sli_bist_status_s cn73xx;
	struct cvmx_sli_bist_status_s cn78xx;
	struct cvmx_sli_bist_status_s cn78xxp1;
	struct cvmx_sli_bist_status_cn61xx cnf71xx;
	struct cvmx_sli_bist_status_s cnf75xx;
};

typedef union cvmx_sli_bist_status cvmx_sli_bist_status_t;

/**
 * cvmx_sli_ciu_int_enb
 *
 * Interrupt enable register for a given SLI_CIU_INT_SUM register.
 *
 */
union cvmx_sli_ciu_int_enb {
	u64 u64;
	struct cvmx_sli_ciu_int_enb_s {
		u64 reserved_51_63 : 13;
		u64 m3_un_wi : 1;
		u64 m3_un_b0 : 1;
		u64 m3_up_wi : 1;
		u64 m3_up_b0 : 1;
		u64 m2_un_wi : 1;
		u64 m2_un_b0 : 1;
		u64 m2_up_wi : 1;
		u64 m2_up_b0 : 1;
		u64 m1_un_wi : 1;
		u64 m1_un_b0 : 1;
		u64 m1_up_wi : 1;
		u64 m1_up_b0 : 1;
		u64 m0_un_wi : 1;
		u64 m0_un_b0 : 1;
		u64 m0_up_wi : 1;
		u64 m0_up_b0 : 1;
		u64 m3p0_pppf_err : 1;
		u64 m3p0_pktpf_err : 1;
		u64 m3p0_dmapf_err : 1;
		u64 m2p0_pppf_err : 1;
		u64 m2p0_ppvf_err : 1;
		u64 m2p0_pktpf_err : 1;
		u64 m2p0_pktvf_err : 1;
		u64 m2p0_dmapf_err : 1;
		u64 m2p0_dmavf_err : 1;
		u64 m1p0_pppf_err : 1;
		u64 m1p0_pktpf_err : 1;
		u64 m1p0_dmapf_err : 1;
		u64 m0p1_pppf_err : 1;
		u64 m0p1_ppvf_err : 1;
		u64 m0p1_pktpf_err : 1;
		u64 m0p1_pktvf_err : 1;
		u64 m0p1_dmapf_err : 1;
		u64 m0p1_dmavf_err : 1;
		u64 m0p0_pppf_err : 1;
		u64 m0p0_ppvf_err : 1;
		u64 m0p0_pktpf_err : 1;
		u64 m0p0_pktvf_err : 1;
		u64 m0p0_dmapf_err : 1;
		u64 m0p0_dmavf_err : 1;
		u64 m2v0_flr : 1;
		u64 m2p0_flr : 1;
		u64 reserved_5_8 : 4;
		u64 m0v1_flr : 1;
		u64 m0p1_flr : 1;
		u64 m0v0_flr : 1;
		u64 m0p0_flr : 1;
		u64 rml_to : 1;
	} s;
	struct cvmx_sli_ciu_int_enb_s cn73xx;
	struct cvmx_sli_ciu_int_enb_s cn78xx;
	struct cvmx_sli_ciu_int_enb_s cnf75xx;
};

typedef union cvmx_sli_ciu_int_enb cvmx_sli_ciu_int_enb_t;

/**
 * cvmx_sli_ciu_int_sum
 *
 * The fields in this register are set when an interrupt condition occurs; write 1 to clear.
 * A bit set in this register will send and interrupt to CIU
 */
union cvmx_sli_ciu_int_sum {
	u64 u64;
	struct cvmx_sli_ciu_int_sum_s {
		u64 reserved_51_63 : 13;
		u64 m3_un_wi : 1;
		u64 m3_un_b0 : 1;
		u64 m3_up_wi : 1;
		u64 m3_up_b0 : 1;
		u64 m2_un_wi : 1;
		u64 m2_un_b0 : 1;
		u64 m2_up_wi : 1;
		u64 m2_up_b0 : 1;
		u64 m1_un_wi : 1;
		u64 m1_un_b0 : 1;
		u64 m1_up_wi : 1;
		u64 m1_up_b0 : 1;
		u64 m0_un_wi : 1;
		u64 m0_un_b0 : 1;
		u64 m0_up_wi : 1;
		u64 m0_up_b0 : 1;
		u64 m3p0_pppf_err : 1;
		u64 m3p0_pktpf_err : 1;
		u64 m3p0_dmapf_err : 1;
		u64 m2p0_pppf_err : 1;
		u64 m2p0_ppvf_err : 1;
		u64 m2p0_pktpf_err : 1;
		u64 m2p0_pktvf_err : 1;
		u64 m2p0_dmapf_err : 1;
		u64 m2p0_dmavf_err : 1;
		u64 m1p0_pppf_err : 1;
		u64 m1p0_pktpf_err : 1;
		u64 m1p0_dmapf_err : 1;
		u64 m0p1_pppf_err : 1;
		u64 m0p1_ppvf_err : 1;
		u64 m0p1_pktpf_err : 1;
		u64 m0p1_pktvf_err : 1;
		u64 m0p1_dmapf_err : 1;
		u64 m0p1_dmavf_err : 1;
		u64 m0p0_pppf_err : 1;
		u64 m0p0_ppvf_err : 1;
		u64 m0p0_pktpf_err : 1;
		u64 m0p0_pktvf_err : 1;
		u64 m0p0_dmapf_err : 1;
		u64 m0p0_dmavf_err : 1;
		u64 m2v0_flr : 1;
		u64 m2p0_flr : 1;
		u64 reserved_5_8 : 4;
		u64 m0v1_flr : 1;
		u64 m0p1_flr : 1;
		u64 m0v0_flr : 1;
		u64 m0p0_flr : 1;
		u64 rml_to : 1;
	} s;
	struct cvmx_sli_ciu_int_sum_s cn73xx;
	struct cvmx_sli_ciu_int_sum_s cn78xx;
	struct cvmx_sli_ciu_int_sum_s cnf75xx;
};

typedef union cvmx_sli_ciu_int_sum cvmx_sli_ciu_int_sum_t;

/**
 * cvmx_sli_ctl_port#
 *
 * These registers contains control information for access to ports. Indexed by SLI_PORT_E.
 * Note: SLI_CTL_PORT0 controls PF0.
 */
union cvmx_sli_ctl_portx {
	u64 u64;
	struct cvmx_sli_ctl_portx_s {
		u64 reserved_22_63 : 42;
		u64 intd : 1;
		u64 intc : 1;
		u64 intb : 1;
		u64 inta : 1;
		u64 dis_port : 1;
		u64 waitl_com : 1;
		u64 intd_map : 2;
		u64 intc_map : 2;
		u64 intb_map : 2;
		u64 inta_map : 2;
		u64 ctlp_ro : 1;
		u64 reserved_6_6 : 1;
		u64 ptlp_ro : 1;
		u64 reserved_1_4 : 4;
		u64 wait_com : 1;
	} s;
	struct cvmx_sli_ctl_portx_s cn61xx;
	struct cvmx_sli_ctl_portx_s cn63xx;
	struct cvmx_sli_ctl_portx_s cn63xxp1;
	struct cvmx_sli_ctl_portx_s cn66xx;
	struct cvmx_sli_ctl_portx_s cn68xx;
	struct cvmx_sli_ctl_portx_s cn68xxp1;
	struct cvmx_sli_ctl_portx_cn70xx {
		u64 reserved_22_63 : 42;
		u64 intd : 1;
		u64 intc : 1;
		u64 intb : 1;
		u64 inta : 1;
		u64 dis_port : 1;
		u64 waitl_com : 1;
		u64 intd_map : 2;
		u64 intc_map : 2;
		u64 intb_map : 2;
		u64 inta_map : 2;
		u64 ctlp_ro : 1;
		u64 reserved_6_6 : 1;
		u64 ptlp_ro : 1;
		u64 reserved_4_1 : 4;
		u64 wait_com : 1;
	} cn70xx;
	struct cvmx_sli_ctl_portx_cn70xx cn70xxp1;
	struct cvmx_sli_ctl_portx_cn73xx {
		u64 reserved_18_63 : 46;
		u64 dis_port : 1;
		u64 waitl_com : 1;
		u64 reserved_8_15 : 8;
		u64 ctlp_ro : 1;
		u64 reserved_6_6 : 1;
		u64 ptlp_ro : 1;
		u64 reserved_1_4 : 4;
		u64 wait_com : 1;
	} cn73xx;
	struct cvmx_sli_ctl_portx_cn73xx cn78xx;
	struct cvmx_sli_ctl_portx_cn73xx cn78xxp1;
	struct cvmx_sli_ctl_portx_s cnf71xx;
	struct cvmx_sli_ctl_portx_cn73xx cnf75xx;
};

typedef union cvmx_sli_ctl_portx cvmx_sli_ctl_portx_t;

/**
 * cvmx_sli_ctl_status
 *
 * This register contains control and status for SLI. Write operations to this register are not
 * ordered with write/read operations to the MAC memory space. To ensure that a write has
 * completed, software must read the register before making an access (i.e. MAC memory space)
 * that requires the value of this register to be updated.
 */
union cvmx_sli_ctl_status {
	u64 u64;
	struct cvmx_sli_ctl_status_s {
		u64 reserved_32_63 : 32;
		u64 m2s1_ncbi : 4;
		u64 m2s0_ncbi : 4;
		u64 oci_id : 4;
		u64 p1_ntags : 6;
		u64 p0_ntags : 6;
		u64 chip_rev : 8;
	} s;
	struct cvmx_sli_ctl_status_cn61xx {
		u64 reserved_14_63 : 50;
		u64 p0_ntags : 6;
		u64 chip_rev : 8;
	} cn61xx;
	struct cvmx_sli_ctl_status_cn63xx {
		u64 reserved_20_63 : 44;
		u64 p1_ntags : 6;
		u64 p0_ntags : 6;
		u64 chip_rev : 8;
	} cn63xx;
	struct cvmx_sli_ctl_status_cn63xx cn63xxp1;
	struct cvmx_sli_ctl_status_cn61xx cn66xx;
	struct cvmx_sli_ctl_status_cn63xx cn68xx;
	struct cvmx_sli_ctl_status_cn63xx cn68xxp1;
	struct cvmx_sli_ctl_status_cn63xx cn70xx;
	struct cvmx_sli_ctl_status_cn63xx cn70xxp1;
	struct cvmx_sli_ctl_status_cn73xx {
		u64 reserved_32_63 : 32;
		u64 m2s1_ncbi : 4;
		u64 m2s0_ncbi : 4;
		u64 reserved_20_23 : 4;
		u64 p1_ntags : 6;
		u64 p0_ntags : 6;
		u64 chip_rev : 8;
	} cn73xx;
	struct cvmx_sli_ctl_status_s cn78xx;
	struct cvmx_sli_ctl_status_s cn78xxp1;
	struct cvmx_sli_ctl_status_cn61xx cnf71xx;
	struct cvmx_sli_ctl_status_cn73xx cnf75xx;
};

typedef union cvmx_sli_ctl_status cvmx_sli_ctl_status_t;

/**
 * cvmx_sli_data_out_cnt
 *
 * This register contains the EXEC data out FIFO count and the data unload counter.
 *
 */
union cvmx_sli_data_out_cnt {
	u64 u64;
	struct cvmx_sli_data_out_cnt_s {
		u64 reserved_44_63 : 20;
		u64 p1_ucnt : 16;
		u64 p1_fcnt : 6;
		u64 p0_ucnt : 16;
		u64 p0_fcnt : 6;
	} s;
	struct cvmx_sli_data_out_cnt_s cn61xx;
	struct cvmx_sli_data_out_cnt_s cn63xx;
	struct cvmx_sli_data_out_cnt_s cn63xxp1;
	struct cvmx_sli_data_out_cnt_s cn66xx;
	struct cvmx_sli_data_out_cnt_s cn68xx;
	struct cvmx_sli_data_out_cnt_s cn68xxp1;
	struct cvmx_sli_data_out_cnt_s cn70xx;
	struct cvmx_sli_data_out_cnt_s cn70xxp1;
	struct cvmx_sli_data_out_cnt_s cn73xx;
	struct cvmx_sli_data_out_cnt_s cn78xx;
	struct cvmx_sli_data_out_cnt_s cn78xxp1;
	struct cvmx_sli_data_out_cnt_s cnf71xx;
	struct cvmx_sli_data_out_cnt_s cnf75xx;
};

typedef union cvmx_sli_data_out_cnt cvmx_sli_data_out_cnt_t;

/**
 * cvmx_sli_dbg_data
 *
 * SLI_DBG_DATA = SLI Debug Data Register
 *
 * Value returned on the debug-data lines from the RSLs
 */
union cvmx_sli_dbg_data {
	u64 u64;
	struct cvmx_sli_dbg_data_s {
		u64 reserved_18_63 : 46;
		u64 dsel_ext : 1;
		u64 data : 17;
	} s;
	struct cvmx_sli_dbg_data_s cn61xx;
	struct cvmx_sli_dbg_data_s cn63xx;
	struct cvmx_sli_dbg_data_s cn63xxp1;
	struct cvmx_sli_dbg_data_s cn66xx;
	struct cvmx_sli_dbg_data_s cn68xx;
	struct cvmx_sli_dbg_data_s cn68xxp1;
	struct cvmx_sli_dbg_data_s cnf71xx;
};

typedef union cvmx_sli_dbg_data cvmx_sli_dbg_data_t;

/**
 * cvmx_sli_dbg_select
 *
 * SLI_DBG_SELECT = Debug Select Register
 *
 * Contains the debug select value last written to the RSLs.
 */
union cvmx_sli_dbg_select {
	u64 u64;
	struct cvmx_sli_dbg_select_s {
		u64 reserved_33_63 : 31;
		u64 adbg_sel : 1;
		u64 dbg_sel : 32;
	} s;
	struct cvmx_sli_dbg_select_s cn61xx;
	struct cvmx_sli_dbg_select_s cn63xx;
	struct cvmx_sli_dbg_select_s cn63xxp1;
	struct cvmx_sli_dbg_select_s cn66xx;
	struct cvmx_sli_dbg_select_s cn68xx;
	struct cvmx_sli_dbg_select_s cn68xxp1;
	struct cvmx_sli_dbg_select_s cnf71xx;
};

typedef union cvmx_sli_dbg_select cvmx_sli_dbg_select_t;

/**
 * cvmx_sli_dma#_cnt
 *
 * These registers contain the DMA count values.
 *
 */
union cvmx_sli_dmax_cnt {
	u64 u64;
	struct cvmx_sli_dmax_cnt_s {
		u64 reserved_32_63 : 32;
		u64 cnt : 32;
	} s;
	struct cvmx_sli_dmax_cnt_s cn61xx;
	struct cvmx_sli_dmax_cnt_s cn63xx;
	struct cvmx_sli_dmax_cnt_s cn63xxp1;
	struct cvmx_sli_dmax_cnt_s cn66xx;
	struct cvmx_sli_dmax_cnt_s cn68xx;
	struct cvmx_sli_dmax_cnt_s cn68xxp1;
	struct cvmx_sli_dmax_cnt_s cn70xx;
	struct cvmx_sli_dmax_cnt_s cn70xxp1;
	struct cvmx_sli_dmax_cnt_s cn73xx;
	struct cvmx_sli_dmax_cnt_s cn78xx;
	struct cvmx_sli_dmax_cnt_s cn78xxp1;
	struct cvmx_sli_dmax_cnt_s cnf71xx;
	struct cvmx_sli_dmax_cnt_s cnf75xx;
};

typedef union cvmx_sli_dmax_cnt cvmx_sli_dmax_cnt_t;

/**
 * cvmx_sli_dma#_int_level
 *
 * These registers contain the thresholds for DMA count and timer interrupts.
 *
 */
union cvmx_sli_dmax_int_level {
	u64 u64;
	struct cvmx_sli_dmax_int_level_s {
		u64 time : 32;
		u64 cnt : 32;
	} s;
	struct cvmx_sli_dmax_int_level_s cn61xx;
	struct cvmx_sli_dmax_int_level_s cn63xx;
	struct cvmx_sli_dmax_int_level_s cn63xxp1;
	struct cvmx_sli_dmax_int_level_s cn66xx;
	struct cvmx_sli_dmax_int_level_s cn68xx;
	struct cvmx_sli_dmax_int_level_s cn68xxp1;
	struct cvmx_sli_dmax_int_level_s cn70xx;
	struct cvmx_sli_dmax_int_level_s cn70xxp1;
	struct cvmx_sli_dmax_int_level_s cn73xx;
	struct cvmx_sli_dmax_int_level_s cn78xx;
	struct cvmx_sli_dmax_int_level_s cn78xxp1;
	struct cvmx_sli_dmax_int_level_s cnf71xx;
	struct cvmx_sli_dmax_int_level_s cnf75xx;
};

typedef union cvmx_sli_dmax_int_level cvmx_sli_dmax_int_level_t;

/**
 * cvmx_sli_dma#_tim
 *
 * These registers contain the DMA timer values.
 *
 */
union cvmx_sli_dmax_tim {
	u64 u64;
	struct cvmx_sli_dmax_tim_s {
		u64 reserved_32_63 : 32;
		u64 tim : 32;
	} s;
	struct cvmx_sli_dmax_tim_s cn61xx;
	struct cvmx_sli_dmax_tim_s cn63xx;
	struct cvmx_sli_dmax_tim_s cn63xxp1;
	struct cvmx_sli_dmax_tim_s cn66xx;
	struct cvmx_sli_dmax_tim_s cn68xx;
	struct cvmx_sli_dmax_tim_s cn68xxp1;
	struct cvmx_sli_dmax_tim_s cn70xx;
	struct cvmx_sli_dmax_tim_s cn70xxp1;
	struct cvmx_sli_dmax_tim_s cn73xx;
	struct cvmx_sli_dmax_tim_s cn78xx;
	struct cvmx_sli_dmax_tim_s cn78xxp1;
	struct cvmx_sli_dmax_tim_s cnf71xx;
	struct cvmx_sli_dmax_tim_s cnf75xx;
};

typedef union cvmx_sli_dmax_tim cvmx_sli_dmax_tim_t;

/**
 * cvmx_sli_int_enb_ciu
 *
 * Used to enable the various interrupting conditions of SLI
 *
 */
union cvmx_sli_int_enb_ciu {
	u64 u64;
	struct cvmx_sli_int_enb_ciu_s {
		u64 reserved_62_63 : 2;
		u64 pipe_err : 1;
		u64 ill_pad : 1;
		u64 sprt3_err : 1;
		u64 sprt2_err : 1;
		u64 sprt1_err : 1;
		u64 sprt0_err : 1;
		u64 pins_err : 1;
		u64 pop_err : 1;
		u64 pdi_err : 1;
		u64 pgl_err : 1;
		u64 pin_bp : 1;
		u64 pout_err : 1;
		u64 psldbof : 1;
		u64 pidbof : 1;
		u64 reserved_38_47 : 10;
		u64 dtime : 2;
		u64 dcnt : 2;
		u64 dmafi : 2;
		u64 reserved_29_31 : 3;
		u64 mio_int2 : 1;
		u64 m3_un_wi : 1;
		u64 m3_un_b0 : 1;
		u64 m3_up_wi : 1;
		u64 m3_up_b0 : 1;
		u64 m2_un_wi : 1;
		u64 m2_un_b0 : 1;
		u64 m2_up_wi : 1;
		u64 m2_up_b0 : 1;
		u64 reserved_18_19 : 2;
		u64 mio_int1 : 1;
		u64 mio_int0 : 1;
		u64 m1_un_wi : 1;
		u64 m1_un_b0 : 1;
		u64 m1_up_wi : 1;
		u64 m1_up_b0 : 1;
		u64 m0_un_wi : 1;
		u64 m0_un_b0 : 1;
		u64 m0_up_wi : 1;
		u64 m0_up_b0 : 1;
		u64 reserved_6_7 : 2;
		u64 ptime : 1;
		u64 pcnt : 1;
		u64 iob2big : 1;
		u64 bar0_to : 1;
		u64 reserved_1_1 : 1;
		u64 rml_to : 1;
	} s;
	struct cvmx_sli_int_enb_ciu_cn61xx {
		u64 reserved_61_63 : 3;
		u64 ill_pad : 1;
		u64 sprt3_err : 1;
		u64 sprt2_err : 1;
		u64 sprt1_err : 1;
		u64 sprt0_err : 1;
		u64 pins_err : 1;
		u64 pop_err : 1;
		u64 pdi_err : 1;
		u64 pgl_err : 1;
		u64 pin_bp : 1;
		u64 pout_err : 1;
		u64 psldbof : 1;
		u64 pidbof : 1;
		u64 reserved_38_47 : 10;
		u64 dtime : 2;
		u64 dcnt : 2;
		u64 dmafi : 2;
		u64 reserved_28_31 : 4;
		u64 m3_un_wi : 1;
		u64 m3_un_b0 : 1;
		u64 m3_up_wi : 1;
		u64 m3_up_b0 : 1;
		u64 m2_un_wi : 1;
		u64 m2_un_b0 : 1;
		u64 m2_up_wi : 1;
		u64 m2_up_b0 : 1;
		u64 reserved_18_19 : 2;
		u64 mio_int1 : 1;
		u64 mio_int0 : 1;
		u64 m1_un_wi : 1;
		u64 m1_un_b0 : 1;
		u64 m1_up_wi : 1;
		u64 m1_up_b0 : 1;
		u64 m0_un_wi : 1;
		u64 m0_un_b0 : 1;
		u64 m0_up_wi : 1;
		u64 m0_up_b0 : 1;
		u64 reserved_6_7 : 2;
		u64 ptime : 1;
		u64 pcnt : 1;
		u64 iob2big : 1;
		u64 bar0_to : 1;
		u64 reserved_1_1 : 1;
		u64 rml_to : 1;
	} cn61xx;
	struct cvmx_sli_int_enb_ciu_cn63xx {
		u64 reserved_61_63 : 3;
		u64 ill_pad : 1;
		u64 reserved_58_59 : 2;
		u64 sprt1_err : 1;
		u64 sprt0_err : 1;
		u64 pins_err : 1;
		u64 pop_err : 1;
		u64 pdi_err : 1;
		u64 pgl_err : 1;
		u64 pin_bp : 1;
		u64 pout_err : 1;
		u64 psldbof : 1;
		u64 pidbof : 1;
		u64 reserved_38_47 : 10;
		u64 dtime : 2;
		u64 dcnt : 2;
		u64 dmafi : 2;
		u64 reserved_18_31 : 14;
		u64 mio_int1 : 1;
		u64 mio_int0 : 1;
		u64 m1_un_wi : 1;
		u64 m1_un_b0 : 1;
		u64 m1_up_wi : 1;
		u64 m1_up_b0 : 1;
		u64 m0_un_wi : 1;
		u64 m0_un_b0 : 1;
		u64 m0_up_wi : 1;
		u64 m0_up_b0 : 1;
		u64 reserved_6_7 : 2;
		u64 ptime : 1;
		u64 pcnt : 1;
		u64 iob2big : 1;
		u64 bar0_to : 1;
		u64 reserved_1_1 : 1;
		u64 rml_to : 1;
	} cn63xx;
	struct cvmx_sli_int_enb_ciu_cn63xx cn63xxp1;
	struct cvmx_sli_int_enb_ciu_cn61xx cn66xx;
	struct cvmx_sli_int_enb_ciu_cn68xx {
		u64 reserved_62_63 : 2;
		u64 pipe_err : 1;
		u64 ill_pad : 1;
		u64 reserved_58_59 : 2;
		u64 sprt1_err : 1;
		u64 sprt0_err : 1;
		u64 pins_err : 1;
		u64 pop_err : 1;
		u64 pdi_err : 1;
		u64 pgl_err : 1;
		u64 reserved_51_51 : 1;
		u64 pout_err : 1;
		u64 psldbof : 1;
		u64 pidbof : 1;
		u64 reserved_38_47 : 10;
		u64 dtime : 2;
		u64 dcnt : 2;
		u64 dmafi : 2;
		u64 reserved_18_31 : 14;
		u64 mio_int1 : 1;
		u64 mio_int0 : 1;
		u64 m1_un_wi : 1;
		u64 m1_un_b0 : 1;
		u64 m1_up_wi : 1;
		u64 m1_up_b0 : 1;
		u64 m0_un_wi : 1;
		u64 m0_un_b0 : 1;
		u64 m0_up_wi : 1;
		u64 m0_up_b0 : 1;
		u64 reserved_6_7 : 2;
		u64 ptime : 1;
		u64 pcnt : 1;
		u64 iob2big : 1;
		u64 bar0_to : 1;
		u64 reserved_1_1 : 1;
		u64 rml_to : 1;
	} cn68xx;
	struct cvmx_sli_int_enb_ciu_cn68xx cn68xxp1;
	struct cvmx_sli_int_enb_ciu_cn70xx {
		u64 reserved_63_61 : 3;
		u64 ill_pad : 1;
		u64 sprt3_err : 1;
		u64 sprt2_err : 1;
		u64 sprt1_err : 1;
		u64 sprt0_err : 1;
		u64 pins_err : 1;
		u64 pop_err : 1;
		u64 pdi_err : 1;
		u64 pgl_err : 1;
		u64 pin_bp : 1;
		u64 pout_err : 1;
		u64 psldbof : 1;
		u64 pidbof : 1;
		u64 reserved_47_38 : 10;
		u64 dtime : 2;
		u64 dcnt : 2;
		u64 dmafi : 2;
		u64 reserved_31_29 : 3;
		u64 mio_int2 : 1;
		u64 m3_un_wi : 1;
		u64 m3_un_b0 : 1;
		u64 m3_up_wi : 1;
		u64 m3_up_b0 : 1;
		u64 m2_un_wi : 1;
		u64 m2_un_b0 : 1;
		u64 m2_up_wi : 1;
		u64 m2_up_b0 : 1;
		u64 reserved_19_18 : 2;
		u64 mio_int1 : 1;
		u64 mio_int0 : 1;
		u64 m1_un_wi : 1;
		u64 m1_un_b0 : 1;
		u64 m1_up_wi : 1;
		u64 m1_up_b0 : 1;
		u64 m0_un_wi : 1;
		u64 m0_un_b0 : 1;
		u64 m0_up_wi : 1;
		u64 m0_up_b0 : 1;
		u64 reserved_7_6 : 2;
		u64 ptime : 1;
		u64 pcnt : 1;
		u64 iob2big : 1;
		u64 bar0_to : 1;
		u64 reserved_1_1 : 1;
		u64 rml_to : 1;
	} cn70xx;
	struct cvmx_sli_int_enb_ciu_cn70xx cn70xxp1;
	struct cvmx_sli_int_enb_ciu_cn61xx cnf71xx;
};

typedef union cvmx_sli_int_enb_ciu cvmx_sli_int_enb_ciu_t;

/**
 * cvmx_sli_int_enb_port#
 *
 * When a field in this register is set, and a corresponding interrupt condition asserts in
 * SLI_INT_SUM, an interrupt is generated. Interrupts can be sent to PCIe0 or PCIe1.
 */
union cvmx_sli_int_enb_portx {
	u64 u64;
	struct cvmx_sli_int_enb_portx_s {
		u64 reserved_62_63 : 2;
		u64 pipe_err : 1;
		u64 ill_pad : 1;
		u64 sprt3_err : 1;
		u64 sprt2_err : 1;
		u64 sprt1_err : 1;
		u64 sprt0_err : 1;
		u64 pins_err : 1;
		u64 pop_err : 1;
		u64 pdi_err : 1;
		u64 pgl_err : 1;
		u64 pin_bp : 1;
		u64 pout_err : 1;
		u64 psldbof : 1;
		u64 pidbof : 1;
		u64 reserved_38_47 : 10;
		u64 dtime : 2;
		u64 dcnt : 2;
		u64 dmafi : 2;
		u64 reserved_30_31 : 2;
		u64 mac2_int : 1;
		u64 reserved_28_28 : 1;
		u64 m3_un_wi : 1;
		u64 m3_un_b0 : 1;
		u64 m3_up_wi : 1;
		u64 m3_up_b0 : 1;
		u64 m2_un_wi : 1;
		u64 m2_un_b0 : 1;
		u64 m2_up_wi : 1;
		u64 m2_up_b0 : 1;
		u64 mac1_int : 1;
		u64 mac0_int : 1;
		u64 mio_int1 : 1;
		u64 mio_int0 : 1;
		u64 m1_un_wi : 1;
		u64 m1_un_b0 : 1;
		u64 m1_up_wi : 1;
		u64 m1_up_b0 : 1;
		u64 m0_un_wi : 1;
		u64 m0_un_b0 : 1;
		u64 m0_up_wi : 1;
		u64 m0_up_b0 : 1;
		u64 mio_int3 : 1;
		u64 reserved_6_6 : 1;
		u64 ptime : 1;
		u64 pcnt : 1;
		u64 iob2big : 1;
		u64 bar0_to : 1;
		u64 reserved_1_1 : 1;
		u64 rml_to : 1;
	} s;
	struct cvmx_sli_int_enb_portx_cn61xx {
		u64 reserved_61_63 : 3;
		u64 ill_pad : 1;
		u64 sprt3_err : 1;
		u64 sprt2_err : 1;
		u64 sprt1_err : 1;
		u64 sprt0_err : 1;
		u64 pins_err : 1;
		u64 pop_err : 1;
		u64 pdi_err : 1;
		u64 pgl_err : 1;
		u64 pin_bp : 1;
		u64 pout_err : 1;
		u64 psldbof : 1;
		u64 pidbof : 1;
		u64 reserved_38_47 : 10;
		u64 dtime : 2;
		u64 dcnt : 2;
		u64 dmafi : 2;
		u64 reserved_28_31 : 4;
		u64 m3_un_wi : 1;
		u64 m3_un_b0 : 1;
		u64 m3_up_wi : 1;
		u64 m3_up_b0 : 1;
		u64 m2_un_wi : 1;
		u64 m2_un_b0 : 1;
		u64 m2_up_wi : 1;
		u64 m2_up_b0 : 1;
		u64 mac1_int : 1;
		u64 mac0_int : 1;
		u64 mio_int1 : 1;
		u64 mio_int0 : 1;
		u64 m1_un_wi : 1;
		u64 m1_un_b0 : 1;
		u64 m1_up_wi : 1;
		u64 m1_up_b0 : 1;
		u64 m0_un_wi : 1;
		u64 m0_un_b0 : 1;
		u64 m0_up_wi : 1;
		u64 m0_up_b0 : 1;
		u64 reserved_6_7 : 2;
		u64 ptime : 1;
		u64 pcnt : 1;
		u64 iob2big : 1;
		u64 bar0_to : 1;
		u64 reserved_1_1 : 1;
		u64 rml_to : 1;
	} cn61xx;
	struct cvmx_sli_int_enb_portx_cn63xx {
		u64 reserved_61_63 : 3;
		u64 ill_pad : 1;
		u64 reserved_58_59 : 2;
		u64 sprt1_err : 1;
		u64 sprt0_err : 1;
		u64 pins_err : 1;
		u64 pop_err : 1;
		u64 pdi_err : 1;
		u64 pgl_err : 1;
		u64 pin_bp : 1;
		u64 pout_err : 1;
		u64 psldbof : 1;
		u64 pidbof : 1;
		u64 reserved_38_47 : 10;
		u64 dtime : 2;
		u64 dcnt : 2;
		u64 dmafi : 2;
		u64 reserved_20_31 : 12;
		u64 mac1_int : 1;
		u64 mac0_int : 1;
		u64 mio_int1 : 1;
		u64 mio_int0 : 1;
		u64 m1_un_wi : 1;
		u64 m1_un_b0 : 1;
		u64 m1_up_wi : 1;
		u64 m1_up_b0 : 1;
		u64 m0_un_wi : 1;
		u64 m0_un_b0 : 1;
		u64 m0_up_wi : 1;
		u64 m0_up_b0 : 1;
		u64 reserved_6_7 : 2;
		u64 ptime : 1;
		u64 pcnt : 1;
		u64 iob2big : 1;
		u64 bar0_to : 1;
		u64 reserved_1_1 : 1;
		u64 rml_to : 1;
	} cn63xx;
	struct cvmx_sli_int_enb_portx_cn63xx cn63xxp1;
	struct cvmx_sli_int_enb_portx_cn61xx cn66xx;
	struct cvmx_sli_int_enb_portx_cn68xx {
		u64 reserved_62_63 : 2;
		u64 pipe_err : 1;
		u64 ill_pad : 1;
		u64 reserved_58_59 : 2;
		u64 sprt1_err : 1;
		u64 sprt0_err : 1;
		u64 pins_err : 1;
		u64 pop_err : 1;
		u64 pdi_err : 1;
		u64 pgl_err : 1;
		u64 reserved_51_51 : 1;
		u64 pout_err : 1;
		u64 psldbof : 1;
		u64 pidbof : 1;
		u64 reserved_38_47 : 10;
		u64 dtime : 2;
		u64 dcnt : 2;
		u64 dmafi : 2;
		u64 reserved_20_31 : 12;
		u64 mac1_int : 1;
		u64 mac0_int : 1;
		u64 mio_int1 : 1;
		u64 mio_int0 : 1;
		u64 m1_un_wi : 1;
		u64 m1_un_b0 : 1;
		u64 m1_up_wi : 1;
		u64 m1_up_b0 : 1;
		u64 m0_un_wi : 1;
		u64 m0_un_b0 : 1;
		u64 m0_up_wi : 1;
		u64 m0_up_b0 : 1;
		u64 reserved_6_7 : 2;
		u64 ptime : 1;
		u64 pcnt : 1;
		u64 iob2big : 1;
		u64 bar0_to : 1;
		u64 reserved_1_1 : 1;
		u64 rml_to : 1;
	} cn68xx;
	struct cvmx_sli_int_enb_portx_cn68xx cn68xxp1;
	struct cvmx_sli_int_enb_portx_cn70xx {
		u64 reserved_63_61 : 3;
		u64 ill_pad : 1;
		u64 sprt3_err : 1;
		u64 sprt2_err : 1;
		u64 sprt1_err : 1;
		u64 sprt0_err : 1;
		u64 pins_err : 1;
		u64 pop_err : 1;
		u64 pdi_err : 1;
		u64 pgl_err : 1;
		u64 pin_bp : 1;
		u64 pout_err : 1;
		u64 psldbof : 1;
		u64 pidbof : 1;
		u64 reserved_47_38 : 10;
		u64 dtime : 2;
		u64 dcnt : 2;
		u64 dmafi : 2;
		u64 reserved_31_30 : 2;
		u64 mac2_int : 1;
		u64 mio_int2 : 1;
		u64 m3_un_wi : 1;
		u64 m3_un_b0 : 1;
		u64 m3_up_wi : 1;
		u64 m3_up_b0 : 1;
		u64 m2_un_wi : 1;
		u64 m2_un_b0 : 1;
		u64 m2_up_wi : 1;
		u64 m2_up_b0 : 1;
		u64 mac1_int : 1;
		u64 mac0_int : 1;
		u64 mio_int1 : 1;
		u64 mio_int0 : 1;
		u64 m1_un_wi : 1;
		u64 m1_un_b0 : 1;
		u64 m1_up_wi : 1;
		u64 m1_up_b0 : 1;
		u64 m0_un_wi : 1;
		u64 m0_un_b0 : 1;
		u64 m0_up_wi : 1;
		u64 m0_up_b0 : 1;
		u64 reserved_7_6 : 2;
		u64 ptime : 1;
		u64 pcnt : 1;
		u64 iob2big : 1;
		u64 bar0_to : 1;
		u64 reserved_1_1 : 1;
		u64 rml_to : 1;
	} cn70xx;
	struct cvmx_sli_int_enb_portx_cn70xx cn70xxp1;
	struct cvmx_sli_int_enb_portx_cn78xxp1 {
		u64 reserved_60_63 : 4;
		u64 sprt3_err : 1;
		u64 sprt2_err : 1;
		u64 sprt1_err : 1;
		u64 sprt0_err : 1;
		u64 pins_err : 1;
		u64 pop_err : 1;
		u64 pdi_err : 1;
		u64 pgl_err : 1;
		u64 reserved_50_51 : 2;
		u64 psldbof : 1;
		u64 pidbof : 1;
		u64 reserved_38_47 : 10;
		u64 dtime : 2;
		u64 dcnt : 2;
		u64 dmafi : 2;
		u64 reserved_29_31 : 3;
		u64 vf_err : 1;
		u64 m3_un_wi : 1;
		u64 m3_un_b0 : 1;
		u64 m3_up_wi : 1;
		u64 m3_up_b0 : 1;
		u64 m2_un_wi : 1;
		u64 m2_un_b0 : 1;
		u64 m2_up_wi : 1;
		u64 m2_up_b0 : 1;
		u64 reserved_18_19 : 2;
		u64 mio_int1 : 1;
		u64 mio_int0 : 1;
		u64 m1_un_wi : 1;
		u64 m1_un_b0 : 1;
		u64 m1_up_wi : 1;
		u64 m1_up_b0 : 1;
		u64 m0_un_wi : 1;
		u64 m0_un_b0 : 1;
		u64 m0_up_wi : 1;
		u64 m0_up_b0 : 1;
		u64 mio_int3 : 1;
		u64 mio_int2 : 1;
		u64 ptime : 1;
		u64 pcnt : 1;
		u64 reserved_1_3 : 3;
		u64 rml_to : 1;
	} cn78xxp1;
	struct cvmx_sli_int_enb_portx_cn61xx cnf71xx;
};

typedef union cvmx_sli_int_enb_portx cvmx_sli_int_enb_portx_t;

/**
 * cvmx_sli_int_sum
 *
 * The fields in this register are set when an interrupt condition occurs; write 1 to clear. All
 * fields of the register are valid when a PF reads the register. Not available to VFs, and
 * writes by the
 * VF do not modify the register.
 */
union cvmx_sli_int_sum {
	u64 u64;
	struct cvmx_sli_int_sum_s {
		u64 reserved_62_63 : 2;
		u64 pipe_err : 1;
		u64 ill_pad : 1;
		u64 sprt3_err : 1;
		u64 sprt2_err : 1;
		u64 sprt1_err : 1;
		u64 sprt0_err : 1;
		u64 pins_err : 1;
		u64 pop_err : 1;
		u64 pdi_err : 1;
		u64 pgl_err : 1;
		u64 pin_bp : 1;
		u64 pout_err : 1;
		u64 psldbof : 1;
		u64 pidbof : 1;
		u64 reserved_38_47 : 10;
		u64 dtime : 2;
		u64 dcnt : 2;
		u64 dmafi : 2;
		u64 reserved_30_31 : 2;
		u64 mac2_int : 1;
		u64 reserved_28_28 : 1;
		u64 m3_un_wi : 1;
		u64 m3_un_b0 : 1;
		u64 m3_up_wi : 1;
		u64 m3_up_b0 : 1;
		u64 m2_un_wi : 1;
		u64 m2_un_b0 : 1;
		u64 m2_up_wi : 1;
		u64 m2_up_b0 : 1;
		u64 mac1_int : 1;
		u64 mac0_int : 1;
		u64 mio_int1 : 1;
		u64 mio_int0 : 1;
		u64 m1_un_wi : 1;
		u64 m1_un_b0 : 1;
		u64 m1_up_wi : 1;
		u64 m1_up_b0 : 1;
		u64 m0_un_wi : 1;
		u64 m0_un_b0 : 1;
		u64 m0_up_wi : 1;
		u64 m0_up_b0 : 1;
		u64 mio_int3 : 1;
		u64 reserved_6_6 : 1;
		u64 ptime : 1;
		u64 pcnt : 1;
		u64 iob2big : 1;
		u64 bar0_to : 1;
		u64 reserved_1_1 : 1;
		u64 rml_to : 1;
	} s;
	struct cvmx_sli_int_sum_cn61xx {
		u64 reserved_61_63 : 3;
		u64 ill_pad : 1;
		u64 sprt3_err : 1;
		u64 sprt2_err : 1;
		u64 sprt1_err : 1;
		u64 sprt0_err : 1;
		u64 pins_err : 1;
		u64 pop_err : 1;
		u64 pdi_err : 1;
		u64 pgl_err : 1;
		u64 pin_bp : 1;
		u64 pout_err : 1;
		u64 psldbof : 1;
		u64 pidbof : 1;
		u64 reserved_38_47 : 10;
		u64 dtime : 2;
		u64 dcnt : 2;
		u64 dmafi : 2;
		u64 reserved_28_31 : 4;
		u64 m3_un_wi : 1;
		u64 m3_un_b0 : 1;
		u64 m3_up_wi : 1;
		u64 m3_up_b0 : 1;
		u64 m2_un_wi : 1;
		u64 m2_un_b0 : 1;
		u64 m2_up_wi : 1;
		u64 m2_up_b0 : 1;
		u64 mac1_int : 1;
		u64 mac0_int : 1;
		u64 mio_int1 : 1;
		u64 mio_int0 : 1;
		u64 m1_un_wi : 1;
		u64 m1_un_b0 : 1;
		u64 m1_up_wi : 1;
		u64 m1_up_b0 : 1;
		u64 m0_un_wi : 1;
		u64 m0_un_b0 : 1;
		u64 m0_up_wi : 1;
		u64 m0_up_b0 : 1;
		u64 reserved_6_7 : 2;
		u64 ptime : 1;
		u64 pcnt : 1;
		u64 iob2big : 1;
		u64 bar0_to : 1;
		u64 reserved_1_1 : 1;
		u64 rml_to : 1;
	} cn61xx;
	struct cvmx_sli_int_sum_cn63xx {
		u64 reserved_61_63 : 3;
		u64 ill_pad : 1;
		u64 reserved_58_59 : 2;
		u64 sprt1_err : 1;
		u64 sprt0_err : 1;
		u64 pins_err : 1;
		u64 pop_err : 1;
		u64 pdi_err : 1;
		u64 pgl_err : 1;
		u64 pin_bp : 1;
		u64 pout_err : 1;
		u64 psldbof : 1;
		u64 pidbof : 1;
		u64 reserved_38_47 : 10;
		u64 dtime : 2;
		u64 dcnt : 2;
		u64 dmafi : 2;
		u64 reserved_20_31 : 12;
		u64 mac1_int : 1;
		u64 mac0_int : 1;
		u64 mio_int1 : 1;
		u64 mio_int0 : 1;
		u64 m1_un_wi : 1;
		u64 m1_un_b0 : 1;
		u64 m1_up_wi : 1;
		u64 m1_up_b0 : 1;
		u64 m0_un_wi : 1;
		u64 m0_un_b0 : 1;
		u64 m0_up_wi : 1;
		u64 m0_up_b0 : 1;
		u64 reserved_6_7 : 2;
		u64 ptime : 1;
		u64 pcnt : 1;
		u64 iob2big : 1;
		u64 bar0_to : 1;
		u64 reserved_1_1 : 1;
		u64 rml_to : 1;
	} cn63xx;
	struct cvmx_sli_int_sum_cn63xx cn63xxp1;
	struct cvmx_sli_int_sum_cn61xx cn66xx;
	struct cvmx_sli_int_sum_cn68xx {
		u64 reserved_62_63 : 2;
		u64 pipe_err : 1;
		u64 ill_pad : 1;
		u64 reserved_58_59 : 2;
		u64 sprt1_err : 1;
		u64 sprt0_err : 1;
		u64 pins_err : 1;
		u64 pop_err : 1;
		u64 pdi_err : 1;
		u64 pgl_err : 1;
		u64 reserved_51_51 : 1;
		u64 pout_err : 1;
		u64 psldbof : 1;
		u64 pidbof : 1;
		u64 reserved_38_47 : 10;
		u64 dtime : 2;
		u64 dcnt : 2;
		u64 dmafi : 2;
		u64 reserved_20_31 : 12;
		u64 mac1_int : 1;
		u64 mac0_int : 1;
		u64 mio_int1 : 1;
		u64 mio_int0 : 1;
		u64 m1_un_wi : 1;
		u64 m1_un_b0 : 1;
		u64 m1_up_wi : 1;
		u64 m1_up_b0 : 1;
		u64 m0_un_wi : 1;
		u64 m0_un_b0 : 1;
		u64 m0_up_wi : 1;
		u64 m0_up_b0 : 1;
		u64 reserved_6_7 : 2;
		u64 ptime : 1;
		u64 pcnt : 1;
		u64 iob2big : 1;
		u64 bar0_to : 1;
		u64 reserved_1_1 : 1;
		u64 rml_to : 1;
	} cn68xx;
	struct cvmx_sli_int_sum_cn68xx cn68xxp1;
	struct cvmx_sli_int_sum_cn70xx {
		u64 reserved_61_63 : 3;
		u64 ill_pad : 1;
		u64 sprt3_err : 1;
		u64 sprt2_err : 1;
		u64 sprt1_err : 1;
		u64 sprt0_err : 1;
		u64 pins_err : 1;
		u64 pop_err : 1;
		u64 pdi_err : 1;
		u64 pgl_err : 1;
		u64 pin_bp : 1;
		u64 pout_err : 1;
		u64 psldbof : 1;
		u64 pidbof : 1;
		u64 reserved_38_47 : 10;
		u64 dtime : 2;
		u64 dcnt : 2;
		u64 dmafi : 2;
		u64 reserved_30_31 : 2;
		u64 mac2_int : 1;
		u64 mio_int2 : 1;
		u64 m3_un_wi : 1;
		u64 m3_un_b0 : 1;
		u64 m3_up_wi : 1;
		u64 m3_up_b0 : 1;
		u64 m2_un_wi : 1;
		u64 m2_un_b0 : 1;
		u64 m2_up_wi : 1;
		u64 m2_up_b0 : 1;
		u64 mac1_int : 1;
		u64 mac0_int : 1;
		u64 mio_int1 : 1;
		u64 mio_int0 : 1;
		u64 m1_un_wi : 1;
		u64 m1_un_b0 : 1;
		u64 m1_up_wi : 1;
		u64 m1_up_b0 : 1;
		u64 m0_un_wi : 1;
		u64 m0_un_b0 : 1;
		u64 m0_up_wi : 1;
		u64 m0_up_b0 : 1;
		u64 reserved_6_7 : 2;
		u64 ptime : 1;
		u64 pcnt : 1;
		u64 iob2big : 1;
		u64 bar0_to : 1;
		u64 reserved_1_1 : 1;
		u64 rml_to : 1;
	} cn70xx;
	struct cvmx_sli_int_sum_cn70xx cn70xxp1;
	struct cvmx_sli_int_sum_cn78xxp1 {
		u64 reserved_60_63 : 4;
		u64 sprt3_err : 1;
		u64 sprt2_err : 1;
		u64 sprt1_err : 1;
		u64 sprt0_err : 1;
		u64 pins_err : 1;
		u64 pop_err : 1;
		u64 pdi_err : 1;
		u64 pgl_err : 1;
		u64 reserved_50_51 : 2;
		u64 psldbof : 1;
		u64 pidbof : 1;
		u64 reserved_38_47 : 10;
		u64 dtime : 2;
		u64 dcnt : 2;
		u64 dmafi : 2;
		u64 reserved_29_31 : 3;
		u64 vf_err : 1;
		u64 m3_un_wi : 1;
		u64 m3_un_b0 : 1;
		u64 m3_up_wi : 1;
		u64 m3_up_b0 : 1;
		u64 m2_un_wi : 1;
		u64 m2_un_b0 : 1;
		u64 m2_up_wi : 1;
		u64 m2_up_b0 : 1;
		u64 reserved_18_19 : 2;
		u64 mio_int1 : 1;
		u64 mio_int0 : 1;
		u64 m1_un_wi : 1;
		u64 m1_un_b0 : 1;
		u64 m1_up_wi : 1;
		u64 m1_up_b0 : 1;
		u64 m0_un_wi : 1;
		u64 m0_un_b0 : 1;
		u64 m0_up_wi : 1;
		u64 m0_up_b0 : 1;
		u64 mio_int3 : 1;
		u64 mio_int2 : 1;
		u64 ptime : 1;
		u64 pcnt : 1;
		u64 reserved_1_3 : 3;
		u64 rml_to : 1;
	} cn78xxp1;
	struct cvmx_sli_int_sum_cn61xx cnf71xx;
};

typedef union cvmx_sli_int_sum cvmx_sli_int_sum_t;

/**
 * cvmx_sli_last_win_rdata0
 *
 * The data from the last initiated window read by MAC 0.
 *
 */
union cvmx_sli_last_win_rdata0 {
	u64 u64;
	struct cvmx_sli_last_win_rdata0_s {
		u64 data : 64;
	} s;
	struct cvmx_sli_last_win_rdata0_s cn61xx;
	struct cvmx_sli_last_win_rdata0_s cn63xx;
	struct cvmx_sli_last_win_rdata0_s cn63xxp1;
	struct cvmx_sli_last_win_rdata0_s cn66xx;
	struct cvmx_sli_last_win_rdata0_s cn68xx;
	struct cvmx_sli_last_win_rdata0_s cn68xxp1;
	struct cvmx_sli_last_win_rdata0_s cn70xx;
	struct cvmx_sli_last_win_rdata0_s cn70xxp1;
	struct cvmx_sli_last_win_rdata0_s cnf71xx;
};

typedef union cvmx_sli_last_win_rdata0 cvmx_sli_last_win_rdata0_t;

/**
 * cvmx_sli_last_win_rdata1
 *
 * The data from the last initiated window read by MAC 1.
 *
 */
union cvmx_sli_last_win_rdata1 {
	u64 u64;
	struct cvmx_sli_last_win_rdata1_s {
		u64 data : 64;
	} s;
	struct cvmx_sli_last_win_rdata1_s cn61xx;
	struct cvmx_sli_last_win_rdata1_s cn63xx;
	struct cvmx_sli_last_win_rdata1_s cn63xxp1;
	struct cvmx_sli_last_win_rdata1_s cn66xx;
	struct cvmx_sli_last_win_rdata1_s cn68xx;
	struct cvmx_sli_last_win_rdata1_s cn68xxp1;
	struct cvmx_sli_last_win_rdata1_s cn70xx;
	struct cvmx_sli_last_win_rdata1_s cn70xxp1;
	struct cvmx_sli_last_win_rdata1_s cnf71xx;
};

typedef union cvmx_sli_last_win_rdata1 cvmx_sli_last_win_rdata1_t;

/**
 * cvmx_sli_last_win_rdata2
 *
 * The data from the last initiated window read by MAC 2.
 *
 */
union cvmx_sli_last_win_rdata2 {
	u64 u64;
	struct cvmx_sli_last_win_rdata2_s {
		u64 data : 64;
	} s;
	struct cvmx_sli_last_win_rdata2_s cn61xx;
	struct cvmx_sli_last_win_rdata2_s cn66xx;
	struct cvmx_sli_last_win_rdata2_s cn70xx;
	struct cvmx_sli_last_win_rdata2_s cn70xxp1;
	struct cvmx_sli_last_win_rdata2_s cnf71xx;
};

typedef union cvmx_sli_last_win_rdata2 cvmx_sli_last_win_rdata2_t;

/**
 * cvmx_sli_last_win_rdata3
 *
 * The data from the last initiated window read by MAC 3.
 *
 */
union cvmx_sli_last_win_rdata3 {
	u64 u64;
	struct cvmx_sli_last_win_rdata3_s {
		u64 data : 64;
	} s;
	struct cvmx_sli_last_win_rdata3_s cn61xx;
	struct cvmx_sli_last_win_rdata3_s cn66xx;
	struct cvmx_sli_last_win_rdata3_s cn70xx;
	struct cvmx_sli_last_win_rdata3_s cn70xxp1;
	struct cvmx_sli_last_win_rdata3_s cnf71xx;
};

typedef union cvmx_sli_last_win_rdata3 cvmx_sli_last_win_rdata3_t;

/**
 * cvmx_sli_mac#_pf#_dma_vf_int
 *
 * When an error response is received for a VF DMA transaction read, the appropriate VF indexed
 * bit is set.  The appropriate PF should read the appropriate register.
 * Indexed by (MAC index) SLI_PORT_E.
 * This CSR array is valid only for SLI_PORT_E::PEM0 PF0.
 */
union cvmx_sli_macx_pfx_dma_vf_int {
	u64 u64;
	struct cvmx_sli_macx_pfx_dma_vf_int_s {
		u64 vf_int : 64;
	} s;
	struct cvmx_sli_macx_pfx_dma_vf_int_s cn73xx;
	struct cvmx_sli_macx_pfx_dma_vf_int_s cn78xx;
	struct cvmx_sli_macx_pfx_dma_vf_int_s cnf75xx;
};

typedef union cvmx_sli_macx_pfx_dma_vf_int cvmx_sli_macx_pfx_dma_vf_int_t;

/**
 * cvmx_sli_mac#_pf#_dma_vf_int_enb
 *
 * Indexed by (MAC index) SLI_PORT_E.
 * This CSR array is valid only for SLI_PORT_E::PEM0 PF0.
 */
union cvmx_sli_macx_pfx_dma_vf_int_enb {
	u64 u64;
	struct cvmx_sli_macx_pfx_dma_vf_int_enb_s {
		u64 vf_int_enb : 64;
	} s;
	struct cvmx_sli_macx_pfx_dma_vf_int_enb_s cn73xx;
	struct cvmx_sli_macx_pfx_dma_vf_int_enb_s cn78xx;
	struct cvmx_sli_macx_pfx_dma_vf_int_enb_s cnf75xx;
};

typedef union cvmx_sli_macx_pfx_dma_vf_int_enb cvmx_sli_macx_pfx_dma_vf_int_enb_t;

/**
 * cvmx_sli_mac#_pf#_flr_vf_int
 *
 * Indexed by (MAC index) SLI_PORT_E.
 * This CSR array is valid only for SLI_PORT_E::PEM0 PF0.
 */
union cvmx_sli_macx_pfx_flr_vf_int {
	u64 u64;
	struct cvmx_sli_macx_pfx_flr_vf_int_s {
		u64 vf_int : 64;
	} s;
	struct cvmx_sli_macx_pfx_flr_vf_int_s cn73xx;
	struct cvmx_sli_macx_pfx_flr_vf_int_s cn78xx;
	struct cvmx_sli_macx_pfx_flr_vf_int_s cnf75xx;
};

typedef union cvmx_sli_macx_pfx_flr_vf_int cvmx_sli_macx_pfx_flr_vf_int_t;

/**
 * cvmx_sli_mac#_pf#_int_enb
 *
 * Interrupt enable register for a given PF SLI_MAC()_PF()_INT_SUM register.
 * Indexed by (MAC index) SLI_PORT_E.
 */
union cvmx_sli_macx_pfx_int_enb {
	u64 u64;
	struct cvmx_sli_macx_pfx_int_enb_s {
		u64 pppf_err : 1;
		u64 ppvf_err : 1;
		u64 pktpf_err : 1;
		u64 pktvf_err : 1;
		u64 dmapf_err : 1;
		u64 dmavf_err : 1;
		u64 vf_mbox : 1;
		u64 reserved_38_56 : 19;
		u64 dtime : 2;
		u64 dcnt : 2;
		u64 dmafi : 2;
		u64 reserved_12_31 : 20;
		u64 un_wi : 1;
		u64 un_b0 : 1;
		u64 up_wi : 1;
		u64 up_b0 : 1;
		u64 reserved_6_7 : 2;
		u64 ptime : 1;
		u64 pcnt : 1;
		u64 reserved_2_3 : 2;
		u64 mio_int : 1;
		u64 rml_to : 1;
	} s;
	struct cvmx_sli_macx_pfx_int_enb_s cn73xx;
	struct cvmx_sli_macx_pfx_int_enb_s cn78xx;
	struct cvmx_sli_macx_pfx_int_enb_s cnf75xx;
};

typedef union cvmx_sli_macx_pfx_int_enb cvmx_sli_macx_pfx_int_enb_t;

/**
 * cvmx_sli_mac#_pf#_int_sum
 *
 * Interrupt summary register for a given PF. Indexed (MAC index) by SLI_PORT_E.
 * The fields in this register are set when an interrupt condition occurs; write 1 to clear.
 */
union cvmx_sli_macx_pfx_int_sum {
	u64 u64;
	struct cvmx_sli_macx_pfx_int_sum_s {
		u64 pppf_err : 1;
		u64 ppvf_err : 1;
		u64 pktpf_err : 1;
		u64 pktvf_err : 1;
		u64 dmapf_err : 1;
		u64 dmavf_err : 1;
		u64 vf_mbox : 1;
		u64 reserved_38_56 : 19;
		u64 dtime : 2;
		u64 dcnt : 2;
		u64 dmafi : 2;
		u64 reserved_12_31 : 20;
		u64 un_wi : 1;
		u64 un_b0 : 1;
		u64 up_wi : 1;
		u64 up_b0 : 1;
		u64 reserved_6_7 : 2;
		u64 ptime : 1;
		u64 pcnt : 1;
		u64 reserved_2_3 : 2;
		u64 mio_int : 1;
		u64 rml_to : 1;
	} s;
	struct cvmx_sli_macx_pfx_int_sum_s cn73xx;
	struct cvmx_sli_macx_pfx_int_sum_s cn78xx;
	struct cvmx_sli_macx_pfx_int_sum_s cnf75xx;
};

typedef union cvmx_sli_macx_pfx_int_sum cvmx_sli_macx_pfx_int_sum_t;

/**
 * cvmx_sli_mac#_pf#_mbox_int
 *
 * When a VF to PF MBOX write occurs the appropriate bit is set.
 * Indexed by (MAC index) SLI_PORT_E.
 * This CSR array is valid only for SLI_PORT_E::PEM0 PF0.
 */
union cvmx_sli_macx_pfx_mbox_int {
	u64 u64;
	struct cvmx_sli_macx_pfx_mbox_int_s {
		u64 vf_int : 64;
	} s;
	struct cvmx_sli_macx_pfx_mbox_int_s cn73xx;
	struct cvmx_sli_macx_pfx_mbox_int_s cn78xx;
	struct cvmx_sli_macx_pfx_mbox_int_s cnf75xx;
};

typedef union cvmx_sli_macx_pfx_mbox_int cvmx_sli_macx_pfx_mbox_int_t;

/**
 * cvmx_sli_mac#_pf#_pkt_vf_int
 *
 * When an error response is received for a VF PP transaction read, a doorbell
 * overflow for a ring associated with a VF occurs or an illegal memory access from a VF occurs,
 * the appropriate VF indexed bit is set.  The appropriate PF should read the appropriate
 * register.
 * Indexed by (MAC index) SLI_PORT_E.
 * This CSR array is valid only for SLI_PORT_E::PEM0 PF0.
 */
union cvmx_sli_macx_pfx_pkt_vf_int {
	u64 u64;
	struct cvmx_sli_macx_pfx_pkt_vf_int_s {
		u64 vf_int : 64;
	} s;
	struct cvmx_sli_macx_pfx_pkt_vf_int_s cn73xx;
	struct cvmx_sli_macx_pfx_pkt_vf_int_s cn78xx;
	struct cvmx_sli_macx_pfx_pkt_vf_int_s cnf75xx;
};

typedef union cvmx_sli_macx_pfx_pkt_vf_int cvmx_sli_macx_pfx_pkt_vf_int_t;

/**
 * cvmx_sli_mac#_pf#_pkt_vf_int_enb
 *
 * Indexed by (MAC index) SLI_PORT_E.
 * This CSR array is valid only for SLI_PORT_E::PEM0 PF0.
 */
union cvmx_sli_macx_pfx_pkt_vf_int_enb {
	u64 u64;
	struct cvmx_sli_macx_pfx_pkt_vf_int_enb_s {
		u64 vf_int_enb : 64;
	} s;
	struct cvmx_sli_macx_pfx_pkt_vf_int_enb_s cn73xx;
	struct cvmx_sli_macx_pfx_pkt_vf_int_enb_s cn78xx;
	struct cvmx_sli_macx_pfx_pkt_vf_int_enb_s cnf75xx;
};

typedef union cvmx_sli_macx_pfx_pkt_vf_int_enb cvmx_sli_macx_pfx_pkt_vf_int_enb_t;

/**
 * cvmx_sli_mac#_pf#_pp_vf_int
 *
 * When an error response is received for a VF PP transaction read, the appropriate VF indexed
 * bit is set.  The appropriate PF should read the appropriate register.
 * Indexed by (MAC index) SLI_PORT_E.
 * This CSR array is valid only for SLI_PORT_E::PEM0 PF0.
 */
union cvmx_sli_macx_pfx_pp_vf_int {
	u64 u64;
	struct cvmx_sli_macx_pfx_pp_vf_int_s {
		u64 vf_int : 64;
	} s;
	struct cvmx_sli_macx_pfx_pp_vf_int_s cn73xx;
	struct cvmx_sli_macx_pfx_pp_vf_int_s cn78xx;
	struct cvmx_sli_macx_pfx_pp_vf_int_s cnf75xx;
};

typedef union cvmx_sli_macx_pfx_pp_vf_int cvmx_sli_macx_pfx_pp_vf_int_t;

/**
 * cvmx_sli_mac#_pf#_pp_vf_int_enb
 *
 * Indexed by (MAC index) SLI_PORT_E.
 * This CSR array is valid only for SLI_PORT_E::PEM0 PF0.
 */
union cvmx_sli_macx_pfx_pp_vf_int_enb {
	u64 u64;
	struct cvmx_sli_macx_pfx_pp_vf_int_enb_s {
		u64 vf_int_enb : 64;
	} s;
	struct cvmx_sli_macx_pfx_pp_vf_int_enb_s cn73xx;
	struct cvmx_sli_macx_pfx_pp_vf_int_enb_s cn78xx;
	struct cvmx_sli_macx_pfx_pp_vf_int_enb_s cnf75xx;
};

typedef union cvmx_sli_macx_pfx_pp_vf_int_enb cvmx_sli_macx_pfx_pp_vf_int_enb_t;

/**
 * cvmx_sli_mac_credit_cnt
 *
 * This register contains the number of credits for the MAC port FIFOs used by the SLI. This
 * value needs to be set before S2M traffic flow starts. A write operation to this register
 * causes the credit counts in the SLI for the MAC ports to be reset to the value in this
 * register if the corresponding disable bit in this register is set to 0.
 */
union cvmx_sli_mac_credit_cnt {
	u64 u64;
	struct cvmx_sli_mac_credit_cnt_s {
		u64 reserved_54_63 : 10;
		u64 p1_c_d : 1;
		u64 p1_n_d : 1;
		u64 p1_p_d : 1;
		u64 p0_c_d : 1;
		u64 p0_n_d : 1;
		u64 p0_p_d : 1;
		u64 p1_ccnt : 8;
		u64 p1_ncnt : 8;
		u64 p1_pcnt : 8;
		u64 p0_ccnt : 8;
		u64 p0_ncnt : 8;
		u64 p0_pcnt : 8;
	} s;
	struct cvmx_sli_mac_credit_cnt_s cn61xx;
	struct cvmx_sli_mac_credit_cnt_s cn63xx;
	struct cvmx_sli_mac_credit_cnt_cn63xxp1 {
		u64 reserved_48_63 : 16;
		u64 p1_ccnt : 8;
		u64 p1_ncnt : 8;
		u64 p1_pcnt : 8;
		u64 p0_ccnt : 8;
		u64 p0_ncnt : 8;
		u64 p0_pcnt : 8;
	} cn63xxp1;
	struct cvmx_sli_mac_credit_cnt_s cn66xx;
	struct cvmx_sli_mac_credit_cnt_s cn68xx;
	struct cvmx_sli_mac_credit_cnt_s cn68xxp1;
	struct cvmx_sli_mac_credit_cnt_s cn70xx;
	struct cvmx_sli_mac_credit_cnt_s cn70xxp1;
	struct cvmx_sli_mac_credit_cnt_s cn73xx;
	struct cvmx_sli_mac_credit_cnt_s cn78xx;
	struct cvmx_sli_mac_credit_cnt_s cn78xxp1;
	struct cvmx_sli_mac_credit_cnt_s cnf71xx;
	struct cvmx_sli_mac_credit_cnt_s cnf75xx;
};

typedef union cvmx_sli_mac_credit_cnt cvmx_sli_mac_credit_cnt_t;

/**
 * cvmx_sli_mac_credit_cnt2
 *
 * This register contains the number of credits for the MAC port FIFOs (for MACs 2 and 3) used by
 * the SLI. This value must be set before S2M traffic flow starts. A write to this register
 * causes the credit counts in the SLI for the MAC ports to be reset to the value in this
 * register.
 */
union cvmx_sli_mac_credit_cnt2 {
	u64 u64;
	struct cvmx_sli_mac_credit_cnt2_s {
		u64 reserved_54_63 : 10;
		u64 p3_c_d : 1;
		u64 p3_n_d : 1;
		u64 p3_p_d : 1;
		u64 p2_c_d : 1;
		u64 p2_n_d : 1;
		u64 p2_p_d : 1;
		u64 p3_ccnt : 8;
		u64 p3_ncnt : 8;
		u64 p3_pcnt : 8;
		u64 p2_ccnt : 8;
		u64 p2_ncnt : 8;
		u64 p2_pcnt : 8;
	} s;
	struct cvmx_sli_mac_credit_cnt2_s cn61xx;
	struct cvmx_sli_mac_credit_cnt2_s cn66xx;
	struct cvmx_sli_mac_credit_cnt2_s cn70xx;
	struct cvmx_sli_mac_credit_cnt2_s cn70xxp1;
	struct cvmx_sli_mac_credit_cnt2_s cn73xx;
	struct cvmx_sli_mac_credit_cnt2_s cn78xx;
	struct cvmx_sli_mac_credit_cnt2_s cn78xxp1;
	struct cvmx_sli_mac_credit_cnt2_s cnf71xx;
	struct cvmx_sli_mac_credit_cnt2_s cnf75xx;
};

typedef union cvmx_sli_mac_credit_cnt2 cvmx_sli_mac_credit_cnt2_t;

/**
 * cvmx_sli_mac_number
 *
 * When read from a MAC port, this register returns the MAC's port number, otherwise returns zero.
 *
 */
union cvmx_sli_mac_number {
	u64 u64;
	struct cvmx_sli_mac_number_s {
		u64 reserved_9_63 : 55;
		u64 a_mode : 1;
		u64 num : 8;
	} s;
	struct cvmx_sli_mac_number_s cn61xx;
	struct cvmx_sli_mac_number_cn63xx {
		u64 reserved_8_63 : 56;
		u64 num : 8;
	} cn63xx;
	struct cvmx_sli_mac_number_s cn66xx;
	struct cvmx_sli_mac_number_cn63xx cn68xx;
	struct cvmx_sli_mac_number_cn63xx cn68xxp1;
	struct cvmx_sli_mac_number_s cn70xx;
	struct cvmx_sli_mac_number_s cn70xxp1;
	struct cvmx_sli_mac_number_s cn73xx;
	struct cvmx_sli_mac_number_s cn78xx;
	struct cvmx_sli_mac_number_s cn78xxp1;
	struct cvmx_sli_mac_number_s cnf71xx;
	struct cvmx_sli_mac_number_s cnf75xx;
};

typedef union cvmx_sli_mac_number cvmx_sli_mac_number_t;

/**
 * cvmx_sli_mem_access_ctl
 *
 * This register contains control signals for access to the MAC address space.
 *
 */
union cvmx_sli_mem_access_ctl {
	u64 u64;
	struct cvmx_sli_mem_access_ctl_s {
		u64 reserved_14_63 : 50;
		u64 max_word : 4;
		u64 timer : 10;
	} s;
	struct cvmx_sli_mem_access_ctl_s cn61xx;
	struct cvmx_sli_mem_access_ctl_s cn63xx;
	struct cvmx_sli_mem_access_ctl_s cn63xxp1;
	struct cvmx_sli_mem_access_ctl_s cn66xx;
	struct cvmx_sli_mem_access_ctl_s cn68xx;
	struct cvmx_sli_mem_access_ctl_s cn68xxp1;
	struct cvmx_sli_mem_access_ctl_s cn70xx;
	struct cvmx_sli_mem_access_ctl_s cn70xxp1;
	struct cvmx_sli_mem_access_ctl_s cn73xx;
	struct cvmx_sli_mem_access_ctl_s cn78xx;
	struct cvmx_sli_mem_access_ctl_s cn78xxp1;
	struct cvmx_sli_mem_access_ctl_s cnf71xx;
	struct cvmx_sli_mem_access_ctl_s cnf75xx;
};

typedef union cvmx_sli_mem_access_ctl cvmx_sli_mem_access_ctl_t;

/**
 * cvmx_sli_mem_access_subid#
 *
 * These registers contains address index and control bits for access to memory from cores.
 *
 */
union cvmx_sli_mem_access_subidx {
	u64 u64;
	struct cvmx_sli_mem_access_subidx_s {
		u64 reserved_60_63 : 4;
		u64 pvf : 16;
		u64 reserved_43_43 : 1;
		u64 zero : 1;
		u64 port : 3;
		u64 nmerge : 1;
		u64 esr : 2;
		u64 esw : 2;
		u64 wtype : 2;
		u64 rtype : 2;
		u64 reserved_0_29 : 30;
	} s;
	struct cvmx_sli_mem_access_subidx_cn61xx {
		u64 reserved_43_63 : 21;
		u64 zero : 1;
		u64 port : 3;
		u64 nmerge : 1;
		u64 esr : 2;
		u64 esw : 2;
		u64 wtype : 2;
		u64 rtype : 2;
		u64 ba : 30;
	} cn61xx;
	struct cvmx_sli_mem_access_subidx_cn61xx cn63xx;
	struct cvmx_sli_mem_access_subidx_cn61xx cn63xxp1;
	struct cvmx_sli_mem_access_subidx_cn61xx cn66xx;
	struct cvmx_sli_mem_access_subidx_cn68xx {
		u64 reserved_43_63 : 21;
		u64 zero : 1;
		u64 port : 3;
		u64 nmerge : 1;
		u64 esr : 2;
		u64 esw : 2;
		u64 wtype : 2;
		u64 rtype : 2;
		u64 ba : 28;
		u64 reserved_0_1 : 2;
	} cn68xx;
	struct cvmx_sli_mem_access_subidx_cn68xx cn68xxp1;
	struct cvmx_sli_mem_access_subidx_cn61xx cn70xx;
	struct cvmx_sli_mem_access_subidx_cn61xx cn70xxp1;
	struct cvmx_sli_mem_access_subidx_cn73xx {
		u64 reserved_60_63 : 4;
		u64 pvf : 16;
		u64 reserved_43_43 : 1;
		u64 zero : 1;
		u64 port : 3;
		u64 nmerge : 1;
		u64 esr : 2;
		u64 esw : 2;
		u64 wtype : 2;
		u64 rtype : 2;
		u64 ba : 30;
	} cn73xx;
	struct cvmx_sli_mem_access_subidx_cn73xx cn78xx;
	struct cvmx_sli_mem_access_subidx_cn61xx cn78xxp1;
	struct cvmx_sli_mem_access_subidx_cn61xx cnf71xx;
	struct cvmx_sli_mem_access_subidx_cn73xx cnf75xx;
};

typedef union cvmx_sli_mem_access_subidx cvmx_sli_mem_access_subidx_t;

/**
 * cvmx_sli_mem_ctl
 *
 * This register controls the ECC of the SLI memories.
 *
 */
union cvmx_sli_mem_ctl {
	u64 u64;
	struct cvmx_sli_mem_ctl_s {
		u64 reserved_27_63 : 37;
		u64 tlpn1_fs : 2;
		u64 tlpn1_ecc : 1;
		u64 tlpp1_fs : 2;
		u64 tlpp1_ecc : 1;
		u64 tlpc1_fs : 2;
		u64 tlpc1_ecc : 1;
		u64 tlpn0_fs : 2;
		u64 tlpn0_ecc : 1;
		u64 tlpp0_fs : 2;
		u64 tlpp0_ecc : 1;
		u64 tlpc0_fs : 2;
		u64 tlpc0_ecc : 1;
		u64 nppr_fs : 2;
		u64 nppr_ecc : 1;
		u64 cpl1_fs : 2;
		u64 cpl1_ecc : 1;
		u64 cpl0_fs : 2;
		u64 cpl0_ecc : 1;
	} s;
	struct cvmx_sli_mem_ctl_s cn73xx;
	struct cvmx_sli_mem_ctl_s cn78xx;
	struct cvmx_sli_mem_ctl_s cn78xxp1;
	struct cvmx_sli_mem_ctl_s cnf75xx;
};

typedef union cvmx_sli_mem_ctl cvmx_sli_mem_ctl_t;

/**
 * cvmx_sli_mem_int_sum
 *
 * Set when an interrupt condition occurs; write one to clear.
 *
 */
union cvmx_sli_mem_int_sum {
	u64 u64;
	struct cvmx_sli_mem_int_sum_s {
		u64 reserved_18_63 : 46;
		u64 tlpn1_dbe : 1;
		u64 tlpn1_sbe : 1;
		u64 tlpp1_dbe : 1;
		u64 tlpp1_sbe : 1;
		u64 tlpc1_dbe : 1;
		u64 tlpc1_sbe : 1;
		u64 tlpn0_dbe : 1;
		u64 tlpn0_sbe : 1;
		u64 tlpp0_dbe : 1;
		u64 tlpp0_sbe : 1;
		u64 tlpc0_dbe : 1;
		u64 tlpc0_sbe : 1;
		u64 nppr_dbe : 1;
		u64 nppr_sbe : 1;
		u64 cpl1_dbe : 1;
		u64 cpl1_sbe : 1;
		u64 cpl0_dbe : 1;
		u64 cpl0_sbe : 1;
	} s;
	struct cvmx_sli_mem_int_sum_s cn73xx;
	struct cvmx_sli_mem_int_sum_s cn78xx;
	struct cvmx_sli_mem_int_sum_s cn78xxp1;
	struct cvmx_sli_mem_int_sum_s cnf75xx;
};

typedef union cvmx_sli_mem_int_sum cvmx_sli_mem_int_sum_t;

/**
 * cvmx_sli_msi_enb0
 *
 * Used to enable the interrupt generation for the bits in the SLI_MSI_RCV0.
 *
 */
union cvmx_sli_msi_enb0 {
	u64 u64;
	struct cvmx_sli_msi_enb0_s {
		u64 enb : 64;
	} s;
	struct cvmx_sli_msi_enb0_s cn61xx;
	struct cvmx_sli_msi_enb0_s cn63xx;
	struct cvmx_sli_msi_enb0_s cn63xxp1;
	struct cvmx_sli_msi_enb0_s cn66xx;
	struct cvmx_sli_msi_enb0_s cn68xx;
	struct cvmx_sli_msi_enb0_s cn68xxp1;
	struct cvmx_sli_msi_enb0_s cn70xx;
	struct cvmx_sli_msi_enb0_s cn70xxp1;
	struct cvmx_sli_msi_enb0_s cnf71xx;
};

typedef union cvmx_sli_msi_enb0 cvmx_sli_msi_enb0_t;

/**
 * cvmx_sli_msi_enb1
 *
 * Used to enable the interrupt generation for the bits in the SLI_MSI_RCV1.
 *
 */
union cvmx_sli_msi_enb1 {
	u64 u64;
	struct cvmx_sli_msi_enb1_s {
		u64 enb : 64;
	} s;
	struct cvmx_sli_msi_enb1_s cn61xx;
	struct cvmx_sli_msi_enb1_s cn63xx;
	struct cvmx_sli_msi_enb1_s cn63xxp1;
	struct cvmx_sli_msi_enb1_s cn66xx;
	struct cvmx_sli_msi_enb1_s cn68xx;
	struct cvmx_sli_msi_enb1_s cn68xxp1;
	struct cvmx_sli_msi_enb1_s cn70xx;
	struct cvmx_sli_msi_enb1_s cn70xxp1;
	struct cvmx_sli_msi_enb1_s cnf71xx;
};

typedef union cvmx_sli_msi_enb1 cvmx_sli_msi_enb1_t;

/**
 * cvmx_sli_msi_enb2
 *
 * Used to enable the interrupt generation for the bits in the SLI_MSI_RCV2.
 *
 */
union cvmx_sli_msi_enb2 {
	u64 u64;
	struct cvmx_sli_msi_enb2_s {
		u64 enb : 64;
	} s;
	struct cvmx_sli_msi_enb2_s cn61xx;
	struct cvmx_sli_msi_enb2_s cn63xx;
	struct cvmx_sli_msi_enb2_s cn63xxp1;
	struct cvmx_sli_msi_enb2_s cn66xx;
	struct cvmx_sli_msi_enb2_s cn68xx;
	struct cvmx_sli_msi_enb2_s cn68xxp1;
	struct cvmx_sli_msi_enb2_s cn70xx;
	struct cvmx_sli_msi_enb2_s cn70xxp1;
	struct cvmx_sli_msi_enb2_s cnf71xx;
};

typedef union cvmx_sli_msi_enb2 cvmx_sli_msi_enb2_t;

/**
 * cvmx_sli_msi_enb3
 *
 * Used to enable the interrupt generation for the bits in the SLI_MSI_RCV3.
 *
 */
union cvmx_sli_msi_enb3 {
	u64 u64;
	struct cvmx_sli_msi_enb3_s {
		u64 enb : 64;
	} s;
	struct cvmx_sli_msi_enb3_s cn61xx;
	struct cvmx_sli_msi_enb3_s cn63xx;
	struct cvmx_sli_msi_enb3_s cn63xxp1;
	struct cvmx_sli_msi_enb3_s cn66xx;
	struct cvmx_sli_msi_enb3_s cn68xx;
	struct cvmx_sli_msi_enb3_s cn68xxp1;
	struct cvmx_sli_msi_enb3_s cn70xx;
	struct cvmx_sli_msi_enb3_s cn70xxp1;
	struct cvmx_sli_msi_enb3_s cnf71xx;
};

typedef union cvmx_sli_msi_enb3 cvmx_sli_msi_enb3_t;

/**
 * cvmx_sli_msi_rcv0
 *
 * This register contains bits <63:0> of the 256 bits of MSI interrupts.
 *
 */
union cvmx_sli_msi_rcv0 {
	u64 u64;
	struct cvmx_sli_msi_rcv0_s {
		u64 intr : 64;
	} s;
	struct cvmx_sli_msi_rcv0_s cn61xx;
	struct cvmx_sli_msi_rcv0_s cn63xx;
	struct cvmx_sli_msi_rcv0_s cn63xxp1;
	struct cvmx_sli_msi_rcv0_s cn66xx;
	struct cvmx_sli_msi_rcv0_s cn68xx;
	struct cvmx_sli_msi_rcv0_s cn68xxp1;
	struct cvmx_sli_msi_rcv0_s cn70xx;
	struct cvmx_sli_msi_rcv0_s cn70xxp1;
	struct cvmx_sli_msi_rcv0_s cn73xx;
	struct cvmx_sli_msi_rcv0_s cn78xx;
	struct cvmx_sli_msi_rcv0_s cn78xxp1;
	struct cvmx_sli_msi_rcv0_s cnf71xx;
	struct cvmx_sli_msi_rcv0_s cnf75xx;
};

typedef union cvmx_sli_msi_rcv0 cvmx_sli_msi_rcv0_t;

/**
 * cvmx_sli_msi_rcv1
 *
 * This register contains bits <127:64> of the 256 bits of MSI interrupts.
 *
 */
union cvmx_sli_msi_rcv1 {
	u64 u64;
	struct cvmx_sli_msi_rcv1_s {
		u64 intr : 64;
	} s;
	struct cvmx_sli_msi_rcv1_s cn61xx;
	struct cvmx_sli_msi_rcv1_s cn63xx;
	struct cvmx_sli_msi_rcv1_s cn63xxp1;
	struct cvmx_sli_msi_rcv1_s cn66xx;
	struct cvmx_sli_msi_rcv1_s cn68xx;
	struct cvmx_sli_msi_rcv1_s cn68xxp1;
	struct cvmx_sli_msi_rcv1_s cn70xx;
	struct cvmx_sli_msi_rcv1_s cn70xxp1;
	struct cvmx_sli_msi_rcv1_s cn73xx;
	struct cvmx_sli_msi_rcv1_s cn78xx;
	struct cvmx_sli_msi_rcv1_s cn78xxp1;
	struct cvmx_sli_msi_rcv1_s cnf71xx;
	struct cvmx_sli_msi_rcv1_s cnf75xx;
};

typedef union cvmx_sli_msi_rcv1 cvmx_sli_msi_rcv1_t;

/**
 * cvmx_sli_msi_rcv2
 *
 * This register contains bits <191:128> of the 256 bits of MSI interrupts.
 *
 */
union cvmx_sli_msi_rcv2 {
	u64 u64;
	struct cvmx_sli_msi_rcv2_s {
		u64 intr : 64;
	} s;
	struct cvmx_sli_msi_rcv2_s cn61xx;
	struct cvmx_sli_msi_rcv2_s cn63xx;
	struct cvmx_sli_msi_rcv2_s cn63xxp1;
	struct cvmx_sli_msi_rcv2_s cn66xx;
	struct cvmx_sli_msi_rcv2_s cn68xx;
	struct cvmx_sli_msi_rcv2_s cn68xxp1;
	struct cvmx_sli_msi_rcv2_s cn70xx;
	struct cvmx_sli_msi_rcv2_s cn70xxp1;
	struct cvmx_sli_msi_rcv2_s cn73xx;
	struct cvmx_sli_msi_rcv2_s cn78xx;
	struct cvmx_sli_msi_rcv2_s cn78xxp1;
	struct cvmx_sli_msi_rcv2_s cnf71xx;
	struct cvmx_sli_msi_rcv2_s cnf75xx;
};

typedef union cvmx_sli_msi_rcv2 cvmx_sli_msi_rcv2_t;

/**
 * cvmx_sli_msi_rcv3
 *
 * This register contains bits <255:192> of the 256 bits of MSI interrupts.
 *
 */
union cvmx_sli_msi_rcv3 {
	u64 u64;
	struct cvmx_sli_msi_rcv3_s {
		u64 intr : 64;
	} s;
	struct cvmx_sli_msi_rcv3_s cn61xx;
	struct cvmx_sli_msi_rcv3_s cn63xx;
	struct cvmx_sli_msi_rcv3_s cn63xxp1;
	struct cvmx_sli_msi_rcv3_s cn66xx;
	struct cvmx_sli_msi_rcv3_s cn68xx;
	struct cvmx_sli_msi_rcv3_s cn68xxp1;
	struct cvmx_sli_msi_rcv3_s cn70xx;
	struct cvmx_sli_msi_rcv3_s cn70xxp1;
	struct cvmx_sli_msi_rcv3_s cn73xx;
	struct cvmx_sli_msi_rcv3_s cn78xx;
	struct cvmx_sli_msi_rcv3_s cn78xxp1;
	struct cvmx_sli_msi_rcv3_s cnf71xx;
	struct cvmx_sli_msi_rcv3_s cnf75xx;
};

typedef union cvmx_sli_msi_rcv3 cvmx_sli_msi_rcv3_t;

/**
 * cvmx_sli_msi_rd_map
 *
 * This register is used to read the mapping function of the SLI_PCIE_MSI_RCV to SLI_MSI_RCV
 * registers.
 */
union cvmx_sli_msi_rd_map {
	u64 u64;
	struct cvmx_sli_msi_rd_map_s {
		u64 reserved_16_63 : 48;
		u64 rd_int : 8;
		u64 msi_int : 8;
	} s;
	struct cvmx_sli_msi_rd_map_s cn61xx;
	struct cvmx_sli_msi_rd_map_s cn63xx;
	struct cvmx_sli_msi_rd_map_s cn63xxp1;
	struct cvmx_sli_msi_rd_map_s cn66xx;
	struct cvmx_sli_msi_rd_map_s cn68xx;
	struct cvmx_sli_msi_rd_map_s cn68xxp1;
	struct cvmx_sli_msi_rd_map_s cn70xx;
	struct cvmx_sli_msi_rd_map_s cn70xxp1;
	struct cvmx_sli_msi_rd_map_s cn73xx;
	struct cvmx_sli_msi_rd_map_s cn78xx;
	struct cvmx_sli_msi_rd_map_s cn78xxp1;
	struct cvmx_sli_msi_rd_map_s cnf71xx;
	struct cvmx_sli_msi_rd_map_s cnf75xx;
};

typedef union cvmx_sli_msi_rd_map cvmx_sli_msi_rd_map_t;

/**
 * cvmx_sli_msi_w1c_enb0
 *
 * Used to clear bits in SLI_MSI_ENB0.
 *
 */
union cvmx_sli_msi_w1c_enb0 {
	u64 u64;
	struct cvmx_sli_msi_w1c_enb0_s {
		u64 clr : 64;
	} s;
	struct cvmx_sli_msi_w1c_enb0_s cn61xx;
	struct cvmx_sli_msi_w1c_enb0_s cn63xx;
	struct cvmx_sli_msi_w1c_enb0_s cn63xxp1;
	struct cvmx_sli_msi_w1c_enb0_s cn66xx;
	struct cvmx_sli_msi_w1c_enb0_s cn68xx;
	struct cvmx_sli_msi_w1c_enb0_s cn68xxp1;
	struct cvmx_sli_msi_w1c_enb0_s cn70xx;
	struct cvmx_sli_msi_w1c_enb0_s cn70xxp1;
	struct cvmx_sli_msi_w1c_enb0_s cnf71xx;
};

typedef union cvmx_sli_msi_w1c_enb0 cvmx_sli_msi_w1c_enb0_t;

/**
 * cvmx_sli_msi_w1c_enb1
 *
 * Used to clear bits in SLI_MSI_ENB1.
 *
 */
union cvmx_sli_msi_w1c_enb1 {
	u64 u64;
	struct cvmx_sli_msi_w1c_enb1_s {
		u64 clr : 64;
	} s;
	struct cvmx_sli_msi_w1c_enb1_s cn61xx;
	struct cvmx_sli_msi_w1c_enb1_s cn63xx;
	struct cvmx_sli_msi_w1c_enb1_s cn63xxp1;
	struct cvmx_sli_msi_w1c_enb1_s cn66xx;
	struct cvmx_sli_msi_w1c_enb1_s cn68xx;
	struct cvmx_sli_msi_w1c_enb1_s cn68xxp1;
	struct cvmx_sli_msi_w1c_enb1_s cn70xx;
	struct cvmx_sli_msi_w1c_enb1_s cn70xxp1;
	struct cvmx_sli_msi_w1c_enb1_s cnf71xx;
};

typedef union cvmx_sli_msi_w1c_enb1 cvmx_sli_msi_w1c_enb1_t;

/**
 * cvmx_sli_msi_w1c_enb2
 *
 * Used to clear bits in SLI_MSI_ENB2.
 *
 */
union cvmx_sli_msi_w1c_enb2 {
	u64 u64;
	struct cvmx_sli_msi_w1c_enb2_s {
		u64 clr : 64;
	} s;
	struct cvmx_sli_msi_w1c_enb2_s cn61xx;
	struct cvmx_sli_msi_w1c_enb2_s cn63xx;
	struct cvmx_sli_msi_w1c_enb2_s cn63xxp1;
	struct cvmx_sli_msi_w1c_enb2_s cn66xx;
	struct cvmx_sli_msi_w1c_enb2_s cn68xx;
	struct cvmx_sli_msi_w1c_enb2_s cn68xxp1;
	struct cvmx_sli_msi_w1c_enb2_s cn70xx;
	struct cvmx_sli_msi_w1c_enb2_s cn70xxp1;
	struct cvmx_sli_msi_w1c_enb2_s cnf71xx;
};

typedef union cvmx_sli_msi_w1c_enb2 cvmx_sli_msi_w1c_enb2_t;

/**
 * cvmx_sli_msi_w1c_enb3
 *
 * Used to clear bits in SLI_MSI_ENB3.
 *
 */
union cvmx_sli_msi_w1c_enb3 {
	u64 u64;
	struct cvmx_sli_msi_w1c_enb3_s {
		u64 clr : 64;
	} s;
	struct cvmx_sli_msi_w1c_enb3_s cn61xx;
	struct cvmx_sli_msi_w1c_enb3_s cn63xx;
	struct cvmx_sli_msi_w1c_enb3_s cn63xxp1;
	struct cvmx_sli_msi_w1c_enb3_s cn66xx;
	struct cvmx_sli_msi_w1c_enb3_s cn68xx;
	struct cvmx_sli_msi_w1c_enb3_s cn68xxp1;
	struct cvmx_sli_msi_w1c_enb3_s cn70xx;
	struct cvmx_sli_msi_w1c_enb3_s cn70xxp1;
	struct cvmx_sli_msi_w1c_enb3_s cnf71xx;
};

typedef union cvmx_sli_msi_w1c_enb3 cvmx_sli_msi_w1c_enb3_t;

/**
 * cvmx_sli_msi_w1s_enb0
 *
 * Used to set bits in SLI_MSI_ENB0.
 *
 */
union cvmx_sli_msi_w1s_enb0 {
	u64 u64;
	struct cvmx_sli_msi_w1s_enb0_s {
		u64 set : 64;
	} s;
	struct cvmx_sli_msi_w1s_enb0_s cn61xx;
	struct cvmx_sli_msi_w1s_enb0_s cn63xx;
	struct cvmx_sli_msi_w1s_enb0_s cn63xxp1;
	struct cvmx_sli_msi_w1s_enb0_s cn66xx;
	struct cvmx_sli_msi_w1s_enb0_s cn68xx;
	struct cvmx_sli_msi_w1s_enb0_s cn68xxp1;
	struct cvmx_sli_msi_w1s_enb0_s cn70xx;
	struct cvmx_sli_msi_w1s_enb0_s cn70xxp1;
	struct cvmx_sli_msi_w1s_enb0_s cnf71xx;
};

typedef union cvmx_sli_msi_w1s_enb0 cvmx_sli_msi_w1s_enb0_t;

/**
 * cvmx_sli_msi_w1s_enb1
 *
 * SLI_MSI_W1S_ENB0 = SLI MSI Write 1 To Set Enable1
 * Used to set bits in SLI_MSI_ENB1.
 */
union cvmx_sli_msi_w1s_enb1 {
	u64 u64;
	struct cvmx_sli_msi_w1s_enb1_s {
		u64 set : 64;
	} s;
	struct cvmx_sli_msi_w1s_enb1_s cn61xx;
	struct cvmx_sli_msi_w1s_enb1_s cn63xx;
	struct cvmx_sli_msi_w1s_enb1_s cn63xxp1;
	struct cvmx_sli_msi_w1s_enb1_s cn66xx;
	struct cvmx_sli_msi_w1s_enb1_s cn68xx;
	struct cvmx_sli_msi_w1s_enb1_s cn68xxp1;
	struct cvmx_sli_msi_w1s_enb1_s cn70xx;
	struct cvmx_sli_msi_w1s_enb1_s cn70xxp1;
	struct cvmx_sli_msi_w1s_enb1_s cnf71xx;
};

typedef union cvmx_sli_msi_w1s_enb1 cvmx_sli_msi_w1s_enb1_t;

/**
 * cvmx_sli_msi_w1s_enb2
 *
 * Used to set bits in SLI_MSI_ENB2.
 *
 */
union cvmx_sli_msi_w1s_enb2 {
	u64 u64;
	struct cvmx_sli_msi_w1s_enb2_s {
		u64 set : 64;
	} s;
	struct cvmx_sli_msi_w1s_enb2_s cn61xx;
	struct cvmx_sli_msi_w1s_enb2_s cn63xx;
	struct cvmx_sli_msi_w1s_enb2_s cn63xxp1;
	struct cvmx_sli_msi_w1s_enb2_s cn66xx;
	struct cvmx_sli_msi_w1s_enb2_s cn68xx;
	struct cvmx_sli_msi_w1s_enb2_s cn68xxp1;
	struct cvmx_sli_msi_w1s_enb2_s cn70xx;
	struct cvmx_sli_msi_w1s_enb2_s cn70xxp1;
	struct cvmx_sli_msi_w1s_enb2_s cnf71xx;
};

typedef union cvmx_sli_msi_w1s_enb2 cvmx_sli_msi_w1s_enb2_t;

/**
 * cvmx_sli_msi_w1s_enb3
 *
 * Used to set bits in SLI_MSI_ENB3.
 *
 */
union cvmx_sli_msi_w1s_enb3 {
	u64 u64;
	struct cvmx_sli_msi_w1s_enb3_s {
		u64 set : 64;
	} s;
	struct cvmx_sli_msi_w1s_enb3_s cn61xx;
	struct cvmx_sli_msi_w1s_enb3_s cn63xx;
	struct cvmx_sli_msi_w1s_enb3_s cn63xxp1;
	struct cvmx_sli_msi_w1s_enb3_s cn66xx;
	struct cvmx_sli_msi_w1s_enb3_s cn68xx;
	struct cvmx_sli_msi_w1s_enb3_s cn68xxp1;
	struct cvmx_sli_msi_w1s_enb3_s cn70xx;
	struct cvmx_sli_msi_w1s_enb3_s cn70xxp1;
	struct cvmx_sli_msi_w1s_enb3_s cnf71xx;
};

typedef union cvmx_sli_msi_w1s_enb3 cvmx_sli_msi_w1s_enb3_t;

/**
 * cvmx_sli_msi_wr_map
 *
 * This register is used to write the mapping function of the SLI_PCIE_MSI_RCV to SLI_MSI_RCV
 * registers. At reset, the mapping function is one-to-one, that is MSI_INT 1 maps to CIU_INT 1,
 * 2 to 2, 3 to 3, etc.
 */
union cvmx_sli_msi_wr_map {
	u64 u64;
	struct cvmx_sli_msi_wr_map_s {
		u64 reserved_16_63 : 48;
		u64 ciu_int : 8;
		u64 msi_int : 8;
	} s;
	struct cvmx_sli_msi_wr_map_s cn61xx;
	struct cvmx_sli_msi_wr_map_s cn63xx;
	struct cvmx_sli_msi_wr_map_s cn63xxp1;
	struct cvmx_sli_msi_wr_map_s cn66xx;
	struct cvmx_sli_msi_wr_map_s cn68xx;
	struct cvmx_sli_msi_wr_map_s cn68xxp1;
	struct cvmx_sli_msi_wr_map_s cn70xx;
	struct cvmx_sli_msi_wr_map_s cn70xxp1;
	struct cvmx_sli_msi_wr_map_s cn73xx;
	struct cvmx_sli_msi_wr_map_s cn78xx;
	struct cvmx_sli_msi_wr_map_s cn78xxp1;
	struct cvmx_sli_msi_wr_map_s cnf71xx;
	struct cvmx_sli_msi_wr_map_s cnf75xx;
};

typedef union cvmx_sli_msi_wr_map cvmx_sli_msi_wr_map_t;

/**
 * cvmx_sli_msix#_table_addr
 *
 * The MSI-X table cannot be burst read or written.
 *
 * The combination of all MSI-X Tables contain (64 + 4) entries - one per
 * ring plus one per PF. (i.e. 64 plus one per valid SLI_MAC()_PF()_INT_SUM
 * present.)
 *
 * The MSI-X table for an individual PF has SLI_PKT_MAC()_PF()_RINFO[TRS]
 * entries for the rings associated to the PF (up to 64 max) plus one
 * more table entry for SLI_MAC()_PF()_INT_SUM. The
 * SLI_MAC()_PF()_INT_SUM-related MSI-X table entry is
 * always entry SLI_MSIX(SLI_PKT_MAC()_PF()_RINFO[TRS])_TABLE_ADDR and
 * always present and valid. All earlier SLI_MSIX()_TABLE_ADDR entries
 * correspond to rings. When SLI_PKT_MAC()_PF()_RINFO[NVFS]=0, SR-IOV
 * virtual functions cannot be used, and all SLI_PKT_MAC()_PF()_RINFO[TRS]+1
 * entries in the PF MSI-X table are present and valid for use by the PF.
 * When SLI_PKT_MAC()_PF()_RINFO[NVFS]!=0, SR-IOV virtual functions may
 * be used, and the first
 *   SLI_PKT_MAC()_PF()_RINFO[NVFS]*SLI_PKT_MAC()_PF()_RINFO[RPVF]
 * entries of the PF MSI-X table are present but not valid, and
 * should never be accessed by the PF.
 *
 * The MSI-X table for an individual VF has SLI_PKT_MAC()_PF()_RINFO[RPVF]
 * entries (up to 8 max), all valid, one per ring that the VF owns.
 */
union cvmx_sli_msixx_table_addr {
	u64 u64;
	struct cvmx_sli_msixx_table_addr_s {
		u64 addr : 64;
	} s;
	struct cvmx_sli_msixx_table_addr_s cn73xx;
	struct cvmx_sli_msixx_table_addr_s cn78xx;
	struct cvmx_sli_msixx_table_addr_s cn78xxp1;
	struct cvmx_sli_msixx_table_addr_s cnf75xx;
};

typedef union cvmx_sli_msixx_table_addr cvmx_sli_msixx_table_addr_t;

/**
 * cvmx_sli_msix#_table_data
 *
 * The MSI-X table cannot be burst read or written. VF/PF access is the same as
 * described for the SLI_MSIX()_TABLE_ADDR.
 */
union cvmx_sli_msixx_table_data {
	u64 u64;
	struct cvmx_sli_msixx_table_data_s {
		u64 reserved_33_63 : 31;
		u64 vector_ctl : 1;
		u64 data : 32;
	} s;
	struct cvmx_sli_msixx_table_data_s cn73xx;
	struct cvmx_sli_msixx_table_data_s cn78xx;
	struct cvmx_sli_msixx_table_data_s cn78xxp1;
	struct cvmx_sli_msixx_table_data_s cnf75xx;
};

typedef union cvmx_sli_msixx_table_data cvmx_sli_msixx_table_data_t;

/**
 * cvmx_sli_msix_mac#_pf_table_addr
 *
 * These registers shadow the four physical MSIX PF ERR entries.
 * Each MAC sees its entry at its own TRS offset.
 */
union cvmx_sli_msix_macx_pf_table_addr {
	u64 u64;
	struct cvmx_sli_msix_macx_pf_table_addr_s {
		u64 addr : 64;
	} s;
	struct cvmx_sli_msix_macx_pf_table_addr_s cn78xxp1;
};

typedef union cvmx_sli_msix_macx_pf_table_addr cvmx_sli_msix_macx_pf_table_addr_t;

/**
 * cvmx_sli_msix_mac#_pf_table_data
 *
 * These registers shadow four physical MSIX PF ERR entries.
 * Each MAC sees its entry at its own TRS offset.
 */
union cvmx_sli_msix_macx_pf_table_data {
	u64 u64;
	struct cvmx_sli_msix_macx_pf_table_data_s {
		u64 reserved_33_63 : 31;
		u64 vector_ctl : 1;
		u64 data : 32;
	} s;
	struct cvmx_sli_msix_macx_pf_table_data_s cn78xxp1;
};

typedef union cvmx_sli_msix_macx_pf_table_data cvmx_sli_msix_macx_pf_table_data_t;

/**
 * cvmx_sli_msix_pba0
 *
 * The MSI-X pending bit array cannot be burst read.
 * In SR-IOV mode, a VF will find its pending completion interrupts in bit
 * positions [(RPVF-1):0]. If RPVF<64, bits [63:RPVF] are returned as zero.
 *
 * Each VF can read their own pending completion interrupts based on the ring/VF
 * configuration. Therefore, a VF sees the PBA as smaller than what is shown below
 * (unless it owns all 64 entries).  Unassigned bits will return zeros.
 *
 * <pre>
 *    RPVF  Interrupts per VF   Pending bits returned
 *    ----  -----------------   ---------------------
 *      0            0          0
 *      1            1          MSG_PND0
 *      2            2          MSG_PND1  - MSG_PND0
 *      4            4          MSG_PND3  - MSG_PND0
 *      8            8          MSG_PND7  - MSG_PND0
 * </pre>
 *
 * If SLI_PKT_MAC()_PF()_RINFO[TRS]=63 (i.e. 64 total DPI Packet Rings configured), a PF will
 * find its pending completion interrupts in bit positions [63:0]. When
 * SLI_PKT_MAC()_PF()_RINFO[TRS]=63,
 * the PF will find its PCIe error interrupt in SLI_MSIX_PBA1, bit position 0.
 *
 * If SLI_PKT_MAC()_PF()_RINFO[TRS]<63 (i.e. 0, 1, 2, 4, or 8 rings configured), a PF will find
 * its ring pending completion interrupts in bit positions [TNR:0]. It will find its PCIe
 * error interrupt in bit position [(TNR+1)]. Bits [63:(TNR+2)] are returned as zero.
 * When SLI_PKT_MAC()_PF()_RINFO[TRS]<63, SLI_MSIX_PBA1 is not used and returns zeros.
 *
 * If SR-IOV Mode is off there is no virtual function support, but the PF can configure up to 65
 * entries (up to 64 DPI Packet Rings plus 1 PF ring) for itself.
 */
union cvmx_sli_msix_pba0 {
	u64 u64;
	struct cvmx_sli_msix_pba0_s {
		u64 msg_pnd : 64;
	} s;
	struct cvmx_sli_msix_pba0_s cn73xx;
	struct cvmx_sli_msix_pba0_s cn78xx;
	struct cvmx_sli_msix_pba0_s cn78xxp1;
	struct cvmx_sli_msix_pba0_s cnf75xx;
};

typedef union cvmx_sli_msix_pba0 cvmx_sli_msix_pba0_t;

/**
 * cvmx_sli_msix_pba1
 *
 * The MSI-X pending bit array cannot be burst read.
 *
 * PF_PND is assigned to PCIe related errors. The error bit can only be found in PBA1 when
 * SLI_PKT_MAC()_PF()_RINFO[TRS]=63 (i.e. 64 total DPI Packet Rings configured).
 *
 * This register is accessible by the PF. A read by a particular PF only
 * returns its own pending status. That is, any PF can read this register, but the hardware
 * ensures
 * that the PF only sees its own status.
 */
union cvmx_sli_msix_pba1 {
	u64 u64;
	struct cvmx_sli_msix_pba1_s {
		u64 reserved_1_63 : 63;
		u64 pf_pnd : 1;
	} s;
	struct cvmx_sli_msix_pba1_s cn73xx;
	struct cvmx_sli_msix_pba1_s cn78xx;
	struct cvmx_sli_msix_pba1_s cn78xxp1;
	struct cvmx_sli_msix_pba1_s cnf75xx;
};

typedef union cvmx_sli_msix_pba1 cvmx_sli_msix_pba1_t;

/**
 * cvmx_sli_nqm_rsp_err_snd_dbg
 *
 * This register is for diagnostic use only.
 *
 */
union cvmx_sli_nqm_rsp_err_snd_dbg {
	u64 u64;
	struct cvmx_sli_nqm_rsp_err_snd_dbg_s {
		u64 reserved_12_63 : 52;
		u64 vf_index : 12;
	} s;
	struct cvmx_sli_nqm_rsp_err_snd_dbg_s cn73xx;
	struct cvmx_sli_nqm_rsp_err_snd_dbg_s cn78xx;
	struct cvmx_sli_nqm_rsp_err_snd_dbg_s cnf75xx;
};

typedef union cvmx_sli_nqm_rsp_err_snd_dbg cvmx_sli_nqm_rsp_err_snd_dbg_t;

/**
 * cvmx_sli_pcie_msi_rcv
 *
 * This is the register where MSI write operations are directed from the MAC.
 *
 */
union cvmx_sli_pcie_msi_rcv {
	u64 u64;
	struct cvmx_sli_pcie_msi_rcv_s {
		u64 reserved_8_63 : 56;
		u64 intr : 8;
	} s;
	struct cvmx_sli_pcie_msi_rcv_s cn61xx;
	struct cvmx_sli_pcie_msi_rcv_s cn63xx;
	struct cvmx_sli_pcie_msi_rcv_s cn63xxp1;
	struct cvmx_sli_pcie_msi_rcv_s cn66xx;
	struct cvmx_sli_pcie_msi_rcv_s cn68xx;
	struct cvmx_sli_pcie_msi_rcv_s cn68xxp1;
	struct cvmx_sli_pcie_msi_rcv_s cn70xx;
	struct cvmx_sli_pcie_msi_rcv_s cn70xxp1;
	struct cvmx_sli_pcie_msi_rcv_s cn73xx;
	struct cvmx_sli_pcie_msi_rcv_s cn78xx;
	struct cvmx_sli_pcie_msi_rcv_s cn78xxp1;
	struct cvmx_sli_pcie_msi_rcv_s cnf71xx;
	struct cvmx_sli_pcie_msi_rcv_s cnf75xx;
};

typedef union cvmx_sli_pcie_msi_rcv cvmx_sli_pcie_msi_rcv_t;

/**
 * cvmx_sli_pcie_msi_rcv_b1
 *
 * This register is where MSI write operations are directed from the MAC. This register can be
 * used by the PCIe and SRIO MACs.
 */
union cvmx_sli_pcie_msi_rcv_b1 {
	u64 u64;
	struct cvmx_sli_pcie_msi_rcv_b1_s {
		u64 reserved_16_63 : 48;
		u64 intr : 8;
		u64 reserved_0_7 : 8;
	} s;
	struct cvmx_sli_pcie_msi_rcv_b1_s cn61xx;
	struct cvmx_sli_pcie_msi_rcv_b1_s cn63xx;
	struct cvmx_sli_pcie_msi_rcv_b1_s cn63xxp1;
	struct cvmx_sli_pcie_msi_rcv_b1_s cn66xx;
	struct cvmx_sli_pcie_msi_rcv_b1_s cn68xx;
	struct cvmx_sli_pcie_msi_rcv_b1_s cn68xxp1;
	struct cvmx_sli_pcie_msi_rcv_b1_s cn70xx;
	struct cvmx_sli_pcie_msi_rcv_b1_s cn70xxp1;
	struct cvmx_sli_pcie_msi_rcv_b1_s cn73xx;
	struct cvmx_sli_pcie_msi_rcv_b1_s cn78xx;
	struct cvmx_sli_pcie_msi_rcv_b1_s cn78xxp1;
	struct cvmx_sli_pcie_msi_rcv_b1_s cnf71xx;
	struct cvmx_sli_pcie_msi_rcv_b1_s cnf75xx;
};

typedef union cvmx_sli_pcie_msi_rcv_b1 cvmx_sli_pcie_msi_rcv_b1_t;

/**
 * cvmx_sli_pcie_msi_rcv_b2
 *
 * This register is where MSI write operations are directed from the MAC.  This register can be
 * used by PCIe and SRIO MACs.
 */
union cvmx_sli_pcie_msi_rcv_b2 {
	u64 u64;
	struct cvmx_sli_pcie_msi_rcv_b2_s {
		u64 reserved_24_63 : 40;
		u64 intr : 8;
		u64 reserved_0_15 : 16;
	} s;
	struct cvmx_sli_pcie_msi_rcv_b2_s cn61xx;
	struct cvmx_sli_pcie_msi_rcv_b2_s cn63xx;
	struct cvmx_sli_pcie_msi_rcv_b2_s cn63xxp1;
	struct cvmx_sli_pcie_msi_rcv_b2_s cn66xx;
	struct cvmx_sli_pcie_msi_rcv_b2_s cn68xx;
	struct cvmx_sli_pcie_msi_rcv_b2_s cn68xxp1;
	struct cvmx_sli_pcie_msi_rcv_b2_s cn70xx;
	struct cvmx_sli_pcie_msi_rcv_b2_s cn70xxp1;
	struct cvmx_sli_pcie_msi_rcv_b2_s cn73xx;
	struct cvmx_sli_pcie_msi_rcv_b2_s cn78xx;
	struct cvmx_sli_pcie_msi_rcv_b2_s cn78xxp1;
	struct cvmx_sli_pcie_msi_rcv_b2_s cnf71xx;
	struct cvmx_sli_pcie_msi_rcv_b2_s cnf75xx;
};

typedef union cvmx_sli_pcie_msi_rcv_b2 cvmx_sli_pcie_msi_rcv_b2_t;

/**
 * cvmx_sli_pcie_msi_rcv_b3
 *
 * This register is where MSI write operations are directed from the MAC. This register can be
 * used by PCIe and SRIO MACs.
 */
union cvmx_sli_pcie_msi_rcv_b3 {
	u64 u64;
	struct cvmx_sli_pcie_msi_rcv_b3_s {
		u64 reserved_32_63 : 32;
		u64 intr : 8;
		u64 reserved_0_23 : 24;
	} s;
	struct cvmx_sli_pcie_msi_rcv_b3_s cn61xx;
	struct cvmx_sli_pcie_msi_rcv_b3_s cn63xx;
	struct cvmx_sli_pcie_msi_rcv_b3_s cn63xxp1;
	struct cvmx_sli_pcie_msi_rcv_b3_s cn66xx;
	struct cvmx_sli_pcie_msi_rcv_b3_s cn68xx;
	struct cvmx_sli_pcie_msi_rcv_b3_s cn68xxp1;
	struct cvmx_sli_pcie_msi_rcv_b3_s cn70xx;
	struct cvmx_sli_pcie_msi_rcv_b3_s cn70xxp1;
	struct cvmx_sli_pcie_msi_rcv_b3_s cn73xx;
	struct cvmx_sli_pcie_msi_rcv_b3_s cn78xx;
	struct cvmx_sli_pcie_msi_rcv_b3_s cn78xxp1;
	struct cvmx_sli_pcie_msi_rcv_b3_s cnf71xx;
	struct cvmx_sli_pcie_msi_rcv_b3_s cnf75xx;
};

typedef union cvmx_sli_pcie_msi_rcv_b3 cvmx_sli_pcie_msi_rcv_b3_t;

/**
 * cvmx_sli_pkt#_cnts
 *
 * This register contains the counters for output rings.
 *
 */
union cvmx_sli_pktx_cnts {
	u64 u64;
	struct cvmx_sli_pktx_cnts_s {
		u64 po_int : 1;
		u64 pi_int : 1;
		u64 mbox_int : 1;
		u64 resend : 1;
		u64 reserved_54_59 : 6;
		u64 timer : 22;
		u64 cnt : 32;
	} s;
	struct cvmx_sli_pktx_cnts_cn61xx {
		u64 reserved_54_63 : 10;
		u64 timer : 22;
		u64 cnt : 32;
	} cn61xx;
	struct cvmx_sli_pktx_cnts_cn61xx cn63xx;
	struct cvmx_sli_pktx_cnts_cn61xx cn63xxp1;
	struct cvmx_sli_pktx_cnts_cn61xx cn66xx;
	struct cvmx_sli_pktx_cnts_cn61xx cn68xx;
	struct cvmx_sli_pktx_cnts_cn61xx cn68xxp1;
	struct cvmx_sli_pktx_cnts_cn70xx {
		u64 reserved_63_54 : 10;
		u64 timer : 22;
		u64 cnt : 32;
	} cn70xx;
	struct cvmx_sli_pktx_cnts_cn70xx cn70xxp1;
	struct cvmx_sli_pktx_cnts_s cn73xx;
	struct cvmx_sli_pktx_cnts_s cn78xx;
	struct cvmx_sli_pktx_cnts_cn78xxp1 {
		u64 po_int : 1;
		u64 pi_int : 1;
		u64 reserved_61_54 : 8;
		u64 timer : 22;
		u64 cnt : 32;
	} cn78xxp1;
	struct cvmx_sli_pktx_cnts_cn61xx cnf71xx;
	struct cvmx_sli_pktx_cnts_s cnf75xx;
};

typedef union cvmx_sli_pktx_cnts cvmx_sli_pktx_cnts_t;

/**
 * cvmx_sli_pkt#_error_info
 *
 * The fields in this register are set when an error conditions occur and can be cleared.
 * These fields are for information purpose only and do NOT generate interrupts.
 */
union cvmx_sli_pktx_error_info {
	u64 u64;
	struct cvmx_sli_pktx_error_info_s {
		u64 reserved_8_63 : 56;
		u64 osize_err : 1;
		u64 nobdell_err : 1;
		u64 pins_err : 1;
		u64 pop_err : 1;
		u64 pdi_err : 1;
		u64 pgl_err : 1;
		u64 psldbof : 1;
		u64 pidbof : 1;
	} s;
	struct cvmx_sli_pktx_error_info_s cn73xx;
	struct cvmx_sli_pktx_error_info_s cn78xx;
	struct cvmx_sli_pktx_error_info_s cnf75xx;
};

typedef union cvmx_sli_pktx_error_info cvmx_sli_pktx_error_info_t;

/**
 * cvmx_sli_pkt#_in_bp
 *
 * "SLI_PKT[0..31]_IN_BP = SLI Packet ring# Input Backpressure
 * The counters and thresholds for input packets to apply backpressure to processing of the
 * packets."
 */
union cvmx_sli_pktx_in_bp {
	u64 u64;
	struct cvmx_sli_pktx_in_bp_s {
		u64 wmark : 32;
		u64 cnt : 32;
	} s;
	struct cvmx_sli_pktx_in_bp_s cn61xx;
	struct cvmx_sli_pktx_in_bp_s cn63xx;
	struct cvmx_sli_pktx_in_bp_s cn63xxp1;
	struct cvmx_sli_pktx_in_bp_s cn66xx;
	struct cvmx_sli_pktx_in_bp_s cn70xx;
	struct cvmx_sli_pktx_in_bp_s cn70xxp1;
	struct cvmx_sli_pktx_in_bp_s cnf71xx;
};

typedef union cvmx_sli_pktx_in_bp cvmx_sli_pktx_in_bp_t;

/**
 * cvmx_sli_pkt#_input_control
 *
 * This register is the control for read operations for gather list and instructions.
 *
 */
union cvmx_sli_pktx_input_control {
	u64 u64;
	struct cvmx_sli_pktx_input_control_s {
		u64 reserved_55_63 : 9;
		u64 rpvf : 7;
		u64 reserved_31_47 : 17;
		u64 mac_num : 2;
		u64 quiet : 1;
		u64 reserved_27_27 : 1;
		u64 rdsize : 2;
		u64 is_64b : 1;
		u64 rst : 1;
		u64 enb : 1;
		u64 pbp_dhi : 13;
		u64 d_nsr : 1;
		u64 d_esr : 2;
		u64 d_ror : 1;
		u64 use_csr : 1;
		u64 nsr : 1;
		u64 esr : 2;
		u64 ror : 1;
	} s;
	struct cvmx_sli_pktx_input_control_cn73xx {
		u64 reserved_55_63 : 9;
		u64 rpvf : 7;
		u64 pvf_num : 16;
		u64 reserved_31_31 : 1;
		u64 mac_num : 2;
		u64 quiet : 1;
		u64 reserved_27_27 : 1;
		u64 rdsize : 2;
		u64 is_64b : 1;
		u64 rst : 1;
		u64 enb : 1;
		u64 pbp_dhi : 13;
		u64 d_nsr : 1;
		u64 d_esr : 2;
		u64 d_ror : 1;
		u64 use_csr : 1;
		u64 nsr : 1;
		u64 esr : 2;
		u64 ror : 1;
	} cn73xx;
	struct cvmx_sli_pktx_input_control_cn73xx cn78xx;
	struct cvmx_sli_pktx_input_control_cn78xxp1 {
		u64 reserved_39_63 : 25;
		u64 vf_num : 7;
		u64 reserved_31_31 : 1;
		u64 mac_num : 2;
		u64 reserved_27_28 : 2;
		u64 rdsize : 2;
		u64 is_64b : 1;
		u64 rst : 1;
		u64 enb : 1;
		u64 pbp_dhi : 13;
		u64 d_nsr : 1;
		u64 d_esr : 2;
		u64 d_ror : 1;
		u64 use_csr : 1;
		u64 nsr : 1;
		u64 esr : 2;
		u64 ror : 1;
	} cn78xxp1;
	struct cvmx_sli_pktx_input_control_cn73xx cnf75xx;
};

typedef union cvmx_sli_pktx_input_control cvmx_sli_pktx_input_control_t;

/**
 * cvmx_sli_pkt#_instr_baddr
 *
 * This register contains the start-of-instruction for input packets. The address must be
 * addressed-aligned to the size of the instruction.
 */
union cvmx_sli_pktx_instr_baddr {
	u64 u64;
	struct cvmx_sli_pktx_instr_baddr_s {
		u64 addr : 61;
		u64 reserved_0_2 : 3;
	} s;
	struct cvmx_sli_pktx_instr_baddr_s cn61xx;
	struct cvmx_sli_pktx_instr_baddr_s cn63xx;
	struct cvmx_sli_pktx_instr_baddr_s cn63xxp1;
	struct cvmx_sli_pktx_instr_baddr_s cn66xx;
	struct cvmx_sli_pktx_instr_baddr_s cn68xx;
	struct cvmx_sli_pktx_instr_baddr_s cn68xxp1;
	struct cvmx_sli_pktx_instr_baddr_s cn70xx;
	struct cvmx_sli_pktx_instr_baddr_s cn70xxp1;
	struct cvmx_sli_pktx_instr_baddr_s cn73xx;
	struct cvmx_sli_pktx_instr_baddr_s cn78xx;
	struct cvmx_sli_pktx_instr_baddr_s cn78xxp1;
	struct cvmx_sli_pktx_instr_baddr_s cnf71xx;
	struct cvmx_sli_pktx_instr_baddr_s cnf75xx;
};

typedef union cvmx_sli_pktx_instr_baddr cvmx_sli_pktx_instr_baddr_t;

/**
 * cvmx_sli_pkt#_instr_baoff_dbell
 *
 * This register contains the doorbell and base address offset for the next read.
 *
 */
union cvmx_sli_pktx_instr_baoff_dbell {
	u64 u64;
	struct cvmx_sli_pktx_instr_baoff_dbell_s {
		u64 aoff : 32;
		u64 dbell : 32;
	} s;
	struct cvmx_sli_pktx_instr_baoff_dbell_s cn61xx;
	struct cvmx_sli_pktx_instr_baoff_dbell_s cn63xx;
	struct cvmx_sli_pktx_instr_baoff_dbell_s cn63xxp1;
	struct cvmx_sli_pktx_instr_baoff_dbell_s cn66xx;
	struct cvmx_sli_pktx_instr_baoff_dbell_s cn68xx;
	struct cvmx_sli_pktx_instr_baoff_dbell_s cn68xxp1;
	struct cvmx_sli_pktx_instr_baoff_dbell_s cn70xx;
	struct cvmx_sli_pktx_instr_baoff_dbell_s cn70xxp1;
	struct cvmx_sli_pktx_instr_baoff_dbell_s cn73xx;
	struct cvmx_sli_pktx_instr_baoff_dbell_s cn78xx;
	struct cvmx_sli_pktx_instr_baoff_dbell_s cn78xxp1;
	struct cvmx_sli_pktx_instr_baoff_dbell_s cnf71xx;
	struct cvmx_sli_pktx_instr_baoff_dbell_s cnf75xx;
};

typedef union cvmx_sli_pktx_instr_baoff_dbell cvmx_sli_pktx_instr_baoff_dbell_t;

/**
 * cvmx_sli_pkt#_instr_fifo_rsize
 *
 * This register contains the FIFO field and ring size for instructions.
 *
 */
union cvmx_sli_pktx_instr_fifo_rsize {
	u64 u64;
	struct cvmx_sli_pktx_instr_fifo_rsize_s {
		u64 max : 9;
		u64 rrp : 9;
		u64 wrp : 9;
		u64 fcnt : 5;
		u64 rsize : 32;
	} s;
	struct cvmx_sli_pktx_instr_fifo_rsize_s cn61xx;
	struct cvmx_sli_pktx_instr_fifo_rsize_s cn63xx;
	struct cvmx_sli_pktx_instr_fifo_rsize_s cn63xxp1;
	struct cvmx_sli_pktx_instr_fifo_rsize_s cn66xx;
	struct cvmx_sli_pktx_instr_fifo_rsize_s cn68xx;
	struct cvmx_sli_pktx_instr_fifo_rsize_s cn68xxp1;
	struct cvmx_sli_pktx_instr_fifo_rsize_s cn70xx;
	struct cvmx_sli_pktx_instr_fifo_rsize_s cn70xxp1;
	struct cvmx_sli_pktx_instr_fifo_rsize_s cn73xx;
	struct cvmx_sli_pktx_instr_fifo_rsize_s cn78xx;
	struct cvmx_sli_pktx_instr_fifo_rsize_s cn78xxp1;
	struct cvmx_sli_pktx_instr_fifo_rsize_s cnf71xx;
	struct cvmx_sli_pktx_instr_fifo_rsize_s cnf75xx;
};

typedef union cvmx_sli_pktx_instr_fifo_rsize cvmx_sli_pktx_instr_fifo_rsize_t;

/**
 * cvmx_sli_pkt#_instr_header
 *
 * "SLI_PKT[0..31]_INSTR_HEADER = SLI Packet ring# Instruction Header.
 * VAlues used to build input packet header."
 */
union cvmx_sli_pktx_instr_header {
	u64 u64;
	struct cvmx_sli_pktx_instr_header_s {
		u64 reserved_44_63 : 20;
		u64 pbp : 1;
		u64 reserved_38_42 : 5;
		u64 rparmode : 2;
		u64 reserved_35_35 : 1;
		u64 rskp_len : 7;
		u64 rngrpext : 2;
		u64 rnqos : 1;
		u64 rngrp : 1;
		u64 rntt : 1;
		u64 rntag : 1;
		u64 use_ihdr : 1;
		u64 reserved_16_20 : 5;
		u64 par_mode : 2;
		u64 reserved_13_13 : 1;
		u64 skp_len : 7;
		u64 ngrpext : 2;
		u64 nqos : 1;
		u64 ngrp : 1;
		u64 ntt : 1;
		u64 ntag : 1;
	} s;
	struct cvmx_sli_pktx_instr_header_cn61xx {
		u64 reserved_44_63 : 20;
		u64 pbp : 1;
		u64 reserved_38_42 : 5;
		u64 rparmode : 2;
		u64 reserved_35_35 : 1;
		u64 rskp_len : 7;
		u64 reserved_26_27 : 2;
		u64 rnqos : 1;
		u64 rngrp : 1;
		u64 rntt : 1;
		u64 rntag : 1;
		u64 use_ihdr : 1;
		u64 reserved_16_20 : 5;
		u64 par_mode : 2;
		u64 reserved_13_13 : 1;
		u64 skp_len : 7;
		u64 reserved_4_5 : 2;
		u64 nqos : 1;
		u64 ngrp : 1;
		u64 ntt : 1;
		u64 ntag : 1;
	} cn61xx;
	struct cvmx_sli_pktx_instr_header_cn61xx cn63xx;
	struct cvmx_sli_pktx_instr_header_cn61xx cn63xxp1;
	struct cvmx_sli_pktx_instr_header_cn61xx cn66xx;
	struct cvmx_sli_pktx_instr_header_s cn68xx;
	struct cvmx_sli_pktx_instr_header_cn61xx cn68xxp1;
	struct cvmx_sli_pktx_instr_header_cn70xx {
		u64 reserved_44_63 : 20;
		u64 pbp : 1;
		u64 reserved_38_42 : 5;
		u64 rparmode : 2;
		u64 reserved_35_35 : 1;
		u64 rskp_len : 7;
		u64 reserved_27_26 : 2;
		u64 rnqos : 1;
		u64 rngrp : 1;
		u64 rntt : 1;
		u64 rntag : 1;
		u64 use_ihdr : 1;
		u64 reserved_20_16 : 5;
		u64 par_mode : 2;
		u64 reserved_13_13 : 1;
		u64 skp_len : 7;
		u64 reserved_5_4 : 2;
		u64 nqos : 1;
		u64 ngrp : 1;
		u64 ntt : 1;
		u64 ntag : 1;
	} cn70xx;
	struct cvmx_sli_pktx_instr_header_cn70xx cn70xxp1;
	struct cvmx_sli_pktx_instr_header_cn61xx cnf71xx;
};

typedef union cvmx_sli_pktx_instr_header cvmx_sli_pktx_instr_header_t;

/**
 * cvmx_sli_pkt#_int_levels
 *
 * This register contains output-packet interrupt levels.
 *
 */
union cvmx_sli_pktx_int_levels {
	u64 u64;
	struct cvmx_sli_pktx_int_levels_s {
		u64 reserved_54_63 : 10;
		u64 time : 22;
		u64 cnt : 32;
	} s;
	struct cvmx_sli_pktx_int_levels_s cn73xx;
	struct cvmx_sli_pktx_int_levels_s cn78xx;
	struct cvmx_sli_pktx_int_levels_s cn78xxp1;
	struct cvmx_sli_pktx_int_levels_s cnf75xx;
};

typedef union cvmx_sli_pktx_int_levels cvmx_sli_pktx_int_levels_t;

/**
 * cvmx_sli_pkt#_mbox_int
 *
 * This register contains information to service mbox interrupts to the VF
 * when the PF writes SLI_PKT()_PF_VF_MBOX_SIG(0).
 */
union cvmx_sli_pktx_mbox_int {
	u64 u64;
	struct cvmx_sli_pktx_mbox_int_s {
		u64 po_int : 1;
		u64 pi_int : 1;
		u64 mbox_int : 1;
		u64 resend : 1;
		u64 reserved_1_59 : 59;
		u64 mbox_en : 1;
	} s;
	struct cvmx_sli_pktx_mbox_int_s cn73xx;
	struct cvmx_sli_pktx_mbox_int_s cn78xx;
	struct cvmx_sli_pktx_mbox_int_s cnf75xx;
};

typedef union cvmx_sli_pktx_mbox_int cvmx_sli_pktx_mbox_int_t;

/**
 * cvmx_sli_pkt#_out_size
 *
 * This register contains the BSIZE and ISIZE for output packet rings.
 *
 */
union cvmx_sli_pktx_out_size {
	u64 u64;
	struct cvmx_sli_pktx_out_size_s {
		u64 reserved_23_63 : 41;
		u64 isize : 7;
		u64 bsize : 16;
	} s;
	struct cvmx_sli_pktx_out_size_s cn61xx;
	struct cvmx_sli_pktx_out_size_s cn63xx;
	struct cvmx_sli_pktx_out_size_s cn63xxp1;
	struct cvmx_sli_pktx_out_size_s cn66xx;
	struct cvmx_sli_pktx_out_size_s cn68xx;
	struct cvmx_sli_pktx_out_size_s cn68xxp1;
	struct cvmx_sli_pktx_out_size_s cn70xx;
	struct cvmx_sli_pktx_out_size_s cn70xxp1;
	struct cvmx_sli_pktx_out_size_cn73xx {
		u64 reserved_22_63 : 42;
		u64 isize : 6;
		u64 bsize : 16;
	} cn73xx;
	struct cvmx_sli_pktx_out_size_cn73xx cn78xx;
	struct cvmx_sli_pktx_out_size_s cn78xxp1;
	struct cvmx_sli_pktx_out_size_s cnf71xx;
	struct cvmx_sli_pktx_out_size_cn73xx cnf75xx;
};

typedef union cvmx_sli_pktx_out_size cvmx_sli_pktx_out_size_t;

/**
 * cvmx_sli_pkt#_output_control
 *
 * This register is the control for read operations for gather list and instructions.
 *
 */
union cvmx_sli_pktx_output_control {
	u64 u64;
	struct cvmx_sli_pktx_output_control_s {
		u64 reserved_14_63 : 50;
		u64 tenb : 1;
		u64 cenb : 1;
		u64 iptr : 1;
		u64 es : 2;
		u64 nsr : 1;
		u64 ror : 1;
		u64 dptr : 1;
		u64 bmode : 1;
		u64 es_p : 2;
		u64 nsr_p : 1;
		u64 ror_p : 1;
		u64 enb : 1;
	} s;
	struct cvmx_sli_pktx_output_control_s cn73xx;
	struct cvmx_sli_pktx_output_control_s cn78xx;
	struct cvmx_sli_pktx_output_control_s cn78xxp1;
	struct cvmx_sli_pktx_output_control_s cnf75xx;
};

typedef union cvmx_sli_pktx_output_control cvmx_sli_pktx_output_control_t;

/**
 * cvmx_sli_pkt#_pf_vf_mbox_sig#
 *
 * These registers are used for communication of data from the PF to the VF and vice versa.
 *
 * There are two registers per ring, SIG(0) and SIG(1). The PF and VF, both, have read and
 * write access to these registers.
 *
 * For PF-to-VF ring interrupts, SLI_PKT(0..63)_MBOX_INT[MBOX_EN] must be set.
 * When [MBOX_EN] is set, writes from the PF to byte 0 of the SIG(0) register will cause
 * an interrupt by setting [MBOX_INT] in the corresponding ring address of
 * SLI_PKT()_MBOX_INT[MBOX_INT],
 * SLI_PKT_IN_DONE()_CNTS[MBOX_INT], and SLI_PKT()_CNTS[MBOX_INT].
 *
 * For VF-to-PF ring interrupt, SLI_MAC()_PF()_INT_ENB[VF_MBOX] must be set.
 * When [VF_MBOX] is set, write from the VF to byte 0 of the SIG(1) register will cause an
 * interrupt by setting ring address VF_INT field in corresponding SLI_MAC()_PF()_MBOX_INT
 * register,
 * which may cause an interrupt to occur through PF.
 *
 * Each PF and VF can only access the rings that it owns as programmed by
 * SLI_PKT_MAC()_PF()_RINFO.
 * The signaling is ring-based. If a VF owns more than one ring, it can ignore the other
 * rings' registers if not needed.
 */
union cvmx_sli_pktx_pf_vf_mbox_sigx {
	u64 u64;
	struct cvmx_sli_pktx_pf_vf_mbox_sigx_s {
		u64 data : 64;
	} s;
	struct cvmx_sli_pktx_pf_vf_mbox_sigx_s cn73xx;
	struct cvmx_sli_pktx_pf_vf_mbox_sigx_s cn78xx;
	struct cvmx_sli_pktx_pf_vf_mbox_sigx_s cnf75xx;
};

typedef union cvmx_sli_pktx_pf_vf_mbox_sigx cvmx_sli_pktx_pf_vf_mbox_sigx_t;

/**
 * cvmx_sli_pkt#_slist_baddr
 *
 * This register contains the start of scatter list for output-packet pointers. This address must
 * be 16-byte aligned.
 */
union cvmx_sli_pktx_slist_baddr {
	u64 u64;
	struct cvmx_sli_pktx_slist_baddr_s {
		u64 addr : 60;
		u64 reserved_0_3 : 4;
	} s;
	struct cvmx_sli_pktx_slist_baddr_s cn61xx;
	struct cvmx_sli_pktx_slist_baddr_s cn63xx;
	struct cvmx_sli_pktx_slist_baddr_s cn63xxp1;
	struct cvmx_sli_pktx_slist_baddr_s cn66xx;
	struct cvmx_sli_pktx_slist_baddr_s cn68xx;
	struct cvmx_sli_pktx_slist_baddr_s cn68xxp1;
	struct cvmx_sli_pktx_slist_baddr_s cn70xx;
	struct cvmx_sli_pktx_slist_baddr_s cn70xxp1;
	struct cvmx_sli_pktx_slist_baddr_s cn73xx;
	struct cvmx_sli_pktx_slist_baddr_s cn78xx;
	struct cvmx_sli_pktx_slist_baddr_s cn78xxp1;
	struct cvmx_sli_pktx_slist_baddr_s cnf71xx;
	struct cvmx_sli_pktx_slist_baddr_s cnf75xx;
};

typedef union cvmx_sli_pktx_slist_baddr cvmx_sli_pktx_slist_baddr_t;

/**
 * cvmx_sli_pkt#_slist_baoff_dbell
 *
 * This register contains the doorbell and base-address offset for next read operation.
 *
 */
union cvmx_sli_pktx_slist_baoff_dbell {
	u64 u64;
	struct cvmx_sli_pktx_slist_baoff_dbell_s {
		u64 aoff : 32;
		u64 dbell : 32;
	} s;
	struct cvmx_sli_pktx_slist_baoff_dbell_s cn61xx;
	struct cvmx_sli_pktx_slist_baoff_dbell_s cn63xx;
	struct cvmx_sli_pktx_slist_baoff_dbell_s cn63xxp1;
	struct cvmx_sli_pktx_slist_baoff_dbell_s cn66xx;
	struct cvmx_sli_pktx_slist_baoff_dbell_s cn68xx;
	struct cvmx_sli_pktx_slist_baoff_dbell_s cn68xxp1;
	struct cvmx_sli_pktx_slist_baoff_dbell_s cn70xx;
	struct cvmx_sli_pktx_slist_baoff_dbell_s cn70xxp1;
	struct cvmx_sli_pktx_slist_baoff_dbell_s cn73xx;
	struct cvmx_sli_pktx_slist_baoff_dbell_s cn78xx;
	struct cvmx_sli_pktx_slist_baoff_dbell_s cn78xxp1;
	struct cvmx_sli_pktx_slist_baoff_dbell_s cnf71xx;
	struct cvmx_sli_pktx_slist_baoff_dbell_s cnf75xx;
};

typedef union cvmx_sli_pktx_slist_baoff_dbell cvmx_sli_pktx_slist_baoff_dbell_t;

/**
 * cvmx_sli_pkt#_slist_fifo_rsize
 *
 * This register contains the number of scatter pointer pairs in the scatter list.
 *
 */
union cvmx_sli_pktx_slist_fifo_rsize {
	u64 u64;
	struct cvmx_sli_pktx_slist_fifo_rsize_s {
		u64 reserved_32_63 : 32;
		u64 rsize : 32;
	} s;
	struct cvmx_sli_pktx_slist_fifo_rsize_s cn61xx;
	struct cvmx_sli_pktx_slist_fifo_rsize_s cn63xx;
	struct cvmx_sli_pktx_slist_fifo_rsize_s cn63xxp1;
	struct cvmx_sli_pktx_slist_fifo_rsize_s cn66xx;
	struct cvmx_sli_pktx_slist_fifo_rsize_s cn68xx;
	struct cvmx_sli_pktx_slist_fifo_rsize_s cn68xxp1;
	struct cvmx_sli_pktx_slist_fifo_rsize_cn70xx {
		u64 reserved_63_32 : 32;
		u64 rsize : 32;
	} cn70xx;
	struct cvmx_sli_pktx_slist_fifo_rsize_cn70xx cn70xxp1;
	struct cvmx_sli_pktx_slist_fifo_rsize_cn70xx cn73xx;
	struct cvmx_sli_pktx_slist_fifo_rsize_cn70xx cn78xx;
	struct cvmx_sli_pktx_slist_fifo_rsize_cn70xx cn78xxp1;
	struct cvmx_sli_pktx_slist_fifo_rsize_s cnf71xx;
	struct cvmx_sli_pktx_slist_fifo_rsize_cn70xx cnf75xx;
};

typedef union cvmx_sli_pktx_slist_fifo_rsize cvmx_sli_pktx_slist_fifo_rsize_t;

/**
 * cvmx_sli_pkt#_vf_int_sum
 *
 * This register contains summary interrupts bits for a VF. A VF read of this register
 * for any of its 8 rings will return the same 8-bit summary for packet input, packet
 * output and mailbox interrupts. If a PF reads this register it will return 0x0.
 */
union cvmx_sli_pktx_vf_int_sum {
	u64 u64;
	struct cvmx_sli_pktx_vf_int_sum_s {
		u64 reserved_40_63 : 24;
		u64 mbox : 8;
		u64 reserved_24_31 : 8;
		u64 pkt_out : 8;
		u64 reserved_8_15 : 8;
		u64 pkt_in : 8;
	} s;
	struct cvmx_sli_pktx_vf_int_sum_s cn73xx;
	struct cvmx_sli_pktx_vf_int_sum_s cn78xx;
	struct cvmx_sli_pktx_vf_int_sum_s cnf75xx;
};

typedef union cvmx_sli_pktx_vf_int_sum cvmx_sli_pktx_vf_int_sum_t;

/**
 * cvmx_sli_pkt#_vf_sig
 *
 * This register is used to signal between PF/VF. These 64 registers are index by VF number.
 *
 */
union cvmx_sli_pktx_vf_sig {
	u64 u64;
	struct cvmx_sli_pktx_vf_sig_s {
		u64 data : 64;
	} s;
	struct cvmx_sli_pktx_vf_sig_s cn78xxp1;
};

typedef union cvmx_sli_pktx_vf_sig cvmx_sli_pktx_vf_sig_t;

/**
 * cvmx_sli_pkt_bist_status
 *
 * This is the built-in self-test (BIST) status register. Each bit is the BIST result of an
 * individual memory (per bit, 0 = pass and 1 = fail).
 */
union cvmx_sli_pkt_bist_status {
	u64 u64;
	struct cvmx_sli_pkt_bist_status_s {
		u64 reserved_22_63 : 42;
		u64 bist : 22;
	} s;
	struct cvmx_sli_pkt_bist_status_s cn73xx;
	struct cvmx_sli_pkt_bist_status_s cn78xx;
	struct cvmx_sli_pkt_bist_status_s cnf75xx;
};

typedef union cvmx_sli_pkt_bist_status cvmx_sli_pkt_bist_status_t;

/**
 * cvmx_sli_pkt_cnt_int
 *
 * This register specifies which output packet rings are interrupting because of packet counters.
 * A bit set in this interrupt register will set a corresponding bit in SLI_PKT_INT and can
 * also cause SLI_MAC()_PF()_INT_SUM[PCNT] to be set if SLI_PKT()_OUTPUT_CONTROL[CENB] is set.
 * When read by a function, this register informs which rings owned by the function (0 to N,
 * N as large as 63) have this interrupt pending.
 */
union cvmx_sli_pkt_cnt_int {
	u64 u64;
	struct cvmx_sli_pkt_cnt_int_s {
		u64 reserved_0_63 : 64;
	} s;
	struct cvmx_sli_pkt_cnt_int_cn61xx {
		u64 reserved_32_63 : 32;
		u64 port : 32;
	} cn61xx;
	struct cvmx_sli_pkt_cnt_int_cn61xx cn63xx;
	struct cvmx_sli_pkt_cnt_int_cn61xx cn63xxp1;
	struct cvmx_sli_pkt_cnt_int_cn61xx cn66xx;
	struct cvmx_sli_pkt_cnt_int_cn61xx cn68xx;
	struct cvmx_sli_pkt_cnt_int_cn61xx cn68xxp1;
	struct cvmx_sli_pkt_cnt_int_cn61xx cn70xx;
	struct cvmx_sli_pkt_cnt_int_cn61xx cn70xxp1;
	struct cvmx_sli_pkt_cnt_int_cn73xx {
		u64 ring : 64;
	} cn73xx;
	struct cvmx_sli_pkt_cnt_int_cn73xx cn78xx;
	struct cvmx_sli_pkt_cnt_int_cn73xx cn78xxp1;
	struct cvmx_sli_pkt_cnt_int_cn61xx cnf71xx;
	struct cvmx_sli_pkt_cnt_int_cn73xx cnf75xx;
};

typedef union cvmx_sli_pkt_cnt_int cvmx_sli_pkt_cnt_int_t;

/**
 * cvmx_sli_pkt_cnt_int_enb
 *
 * Enable for the packets rings that are interrupting because of Packet Counters.
 *
 */
union cvmx_sli_pkt_cnt_int_enb {
	u64 u64;
	struct cvmx_sli_pkt_cnt_int_enb_s {
		u64 reserved_32_63 : 32;
		u64 port : 32;
	} s;
	struct cvmx_sli_pkt_cnt_int_enb_s cn61xx;
	struct cvmx_sli_pkt_cnt_int_enb_s cn63xx;
	struct cvmx_sli_pkt_cnt_int_enb_s cn63xxp1;
	struct cvmx_sli_pkt_cnt_int_enb_s cn66xx;
	struct cvmx_sli_pkt_cnt_int_enb_s cn68xx;
	struct cvmx_sli_pkt_cnt_int_enb_s cn68xxp1;
	struct cvmx_sli_pkt_cnt_int_enb_s cn70xx;
	struct cvmx_sli_pkt_cnt_int_enb_s cn70xxp1;
	struct cvmx_sli_pkt_cnt_int_enb_s cnf71xx;
};

typedef union cvmx_sli_pkt_cnt_int_enb cvmx_sli_pkt_cnt_int_enb_t;

/**
 * cvmx_sli_pkt_ctl
 *
 * Control for packets.
 *
 */
union cvmx_sli_pkt_ctl {
	u64 u64;
	struct cvmx_sli_pkt_ctl_s {
		u64 reserved_5_63 : 59;
		u64 ring_en : 1;
		u64 pkt_bp : 4;
	} s;
	struct cvmx_sli_pkt_ctl_s cn61xx;
	struct cvmx_sli_pkt_ctl_s cn63xx;
	struct cvmx_sli_pkt_ctl_s cn63xxp1;
	struct cvmx_sli_pkt_ctl_s cn66xx;
	struct cvmx_sli_pkt_ctl_s cn68xx;
	struct cvmx_sli_pkt_ctl_s cn68xxp1;
	struct cvmx_sli_pkt_ctl_s cn70xx;
	struct cvmx_sli_pkt_ctl_s cn70xxp1;
	struct cvmx_sli_pkt_ctl_s cnf71xx;
};

typedef union cvmx_sli_pkt_ctl cvmx_sli_pkt_ctl_t;

/**
 * cvmx_sli_pkt_data_out_es
 *
 * The Endian Swap for writing Data Out.
 *
 */
union cvmx_sli_pkt_data_out_es {
	u64 u64;
	struct cvmx_sli_pkt_data_out_es_s {
		u64 es : 64;
	} s;
	struct cvmx_sli_pkt_data_out_es_s cn61xx;
	struct cvmx_sli_pkt_data_out_es_s cn63xx;
	struct cvmx_sli_pkt_data_out_es_s cn63xxp1;
	struct cvmx_sli_pkt_data_out_es_s cn66xx;
	struct cvmx_sli_pkt_data_out_es_s cn68xx;
	struct cvmx_sli_pkt_data_out_es_s cn68xxp1;
	struct cvmx_sli_pkt_data_out_es_s cn70xx;
	struct cvmx_sli_pkt_data_out_es_s cn70xxp1;
	struct cvmx_sli_pkt_data_out_es_s cnf71xx;
};

typedef union cvmx_sli_pkt_data_out_es cvmx_sli_pkt_data_out_es_t;

/**
 * cvmx_sli_pkt_data_out_ns
 *
 * The NS field for the TLP when writing packet data.
 *
 */
union cvmx_sli_pkt_data_out_ns {
	u64 u64;
	struct cvmx_sli_pkt_data_out_ns_s {
		u64 reserved_32_63 : 32;
		u64 nsr : 32;
	} s;
	struct cvmx_sli_pkt_data_out_ns_s cn61xx;
	struct cvmx_sli_pkt_data_out_ns_s cn63xx;
	struct cvmx_sli_pkt_data_out_ns_s cn63xxp1;
	struct cvmx_sli_pkt_data_out_ns_s cn66xx;
	struct cvmx_sli_pkt_data_out_ns_s cn68xx;
	struct cvmx_sli_pkt_data_out_ns_s cn68xxp1;
	struct cvmx_sli_pkt_data_out_ns_s cn70xx;
	struct cvmx_sli_pkt_data_out_ns_s cn70xxp1;
	struct cvmx_sli_pkt_data_out_ns_s cnf71xx;
};

typedef union cvmx_sli_pkt_data_out_ns cvmx_sli_pkt_data_out_ns_t;

/**
 * cvmx_sli_pkt_data_out_ror
 *
 * The ROR field for the TLP when writing Packet Data.
 *
 */
union cvmx_sli_pkt_data_out_ror {
	u64 u64;
	struct cvmx_sli_pkt_data_out_ror_s {
		u64 reserved_32_63 : 32;
		u64 ror : 32;
	} s;
	struct cvmx_sli_pkt_data_out_ror_s cn61xx;
	struct cvmx_sli_pkt_data_out_ror_s cn63xx;
	struct cvmx_sli_pkt_data_out_ror_s cn63xxp1;
	struct cvmx_sli_pkt_data_out_ror_s cn66xx;
	struct cvmx_sli_pkt_data_out_ror_s cn68xx;
	struct cvmx_sli_pkt_data_out_ror_s cn68xxp1;
	struct cvmx_sli_pkt_data_out_ror_s cn70xx;
	struct cvmx_sli_pkt_data_out_ror_s cn70xxp1;
	struct cvmx_sli_pkt_data_out_ror_s cnf71xx;
};

typedef union cvmx_sli_pkt_data_out_ror cvmx_sli_pkt_data_out_ror_t;

/**
 * cvmx_sli_pkt_dpaddr
 *
 * Used to detemine address and attributes for packet data writes.
 *
 */
union cvmx_sli_pkt_dpaddr {
	u64 u64;
	struct cvmx_sli_pkt_dpaddr_s {
		u64 reserved_32_63 : 32;
		u64 dptr : 32;
	} s;
	struct cvmx_sli_pkt_dpaddr_s cn61xx;
	struct cvmx_sli_pkt_dpaddr_s cn63xx;
	struct cvmx_sli_pkt_dpaddr_s cn63xxp1;
	struct cvmx_sli_pkt_dpaddr_s cn66xx;
	struct cvmx_sli_pkt_dpaddr_s cn68xx;
	struct cvmx_sli_pkt_dpaddr_s cn68xxp1;
	struct cvmx_sli_pkt_dpaddr_s cn70xx;
	struct cvmx_sli_pkt_dpaddr_s cn70xxp1;
	struct cvmx_sli_pkt_dpaddr_s cnf71xx;
};

typedef union cvmx_sli_pkt_dpaddr cvmx_sli_pkt_dpaddr_t;

/**
 * cvmx_sli_pkt_gbl_control
 *
 * This register contains control bits that affect all packet rings.
 *
 */
union cvmx_sli_pkt_gbl_control {
	u64 u64;
	struct cvmx_sli_pkt_gbl_control_s {
		u64 reserved_32_63 : 32;
		u64 qtime : 16;
		u64 reserved_14_15 : 2;
		u64 bpkind : 6;
		u64 reserved_4_7 : 4;
		u64 pkpfval : 1;
		u64 bpflr_d : 1;
		u64 noptr_d : 1;
		u64 picnt_d : 1;
	} s;
	struct cvmx_sli_pkt_gbl_control_s cn73xx;
	struct cvmx_sli_pkt_gbl_control_s cn78xx;
	struct cvmx_sli_pkt_gbl_control_s cnf75xx;
};

typedef union cvmx_sli_pkt_gbl_control cvmx_sli_pkt_gbl_control_t;

/**
 * cvmx_sli_pkt_in_bp
 *
 * Which input rings have backpressure applied.
 *
 */
union cvmx_sli_pkt_in_bp {
	u64 u64;
	struct cvmx_sli_pkt_in_bp_s {
		u64 reserved_32_63 : 32;
		u64 bp : 32;
	} s;
	struct cvmx_sli_pkt_in_bp_s cn61xx;
	struct cvmx_sli_pkt_in_bp_s cn63xx;
	struct cvmx_sli_pkt_in_bp_s cn63xxp1;
	struct cvmx_sli_pkt_in_bp_s cn66xx;
	struct cvmx_sli_pkt_in_bp_s cn70xx;
	struct cvmx_sli_pkt_in_bp_s cn70xxp1;
	struct cvmx_sli_pkt_in_bp_s cnf71xx;
};

typedef union cvmx_sli_pkt_in_bp cvmx_sli_pkt_in_bp_t;

/**
 * cvmx_sli_pkt_in_done#_cnts
 *
 * This register contains counters for instructions completed on input rings.
 *
 */
union cvmx_sli_pkt_in_donex_cnts {
	u64 u64;
	struct cvmx_sli_pkt_in_donex_cnts_s {
		u64 po_int : 1;
		u64 pi_int : 1;
		u64 mbox_int : 1;
		u64 resend : 1;
		u64 reserved_49_59 : 11;
		u64 cint_enb : 1;
		u64 wmark : 16;
		u64 cnt : 32;
	} s;
	struct cvmx_sli_pkt_in_donex_cnts_cn61xx {
		u64 reserved_32_63 : 32;
		u64 cnt : 32;
	} cn61xx;
	struct cvmx_sli_pkt_in_donex_cnts_cn61xx cn63xx;
	struct cvmx_sli_pkt_in_donex_cnts_cn61xx cn63xxp1;
	struct cvmx_sli_pkt_in_donex_cnts_cn61xx cn66xx;
	struct cvmx_sli_pkt_in_donex_cnts_cn61xx cn68xx;
	struct cvmx_sli_pkt_in_donex_cnts_cn61xx cn68xxp1;
	struct cvmx_sli_pkt_in_donex_cnts_cn70xx {
		u64 reserved_63_32 : 32;
		u64 cnt : 32;
	} cn70xx;
	struct cvmx_sli_pkt_in_donex_cnts_cn70xx cn70xxp1;
	struct cvmx_sli_pkt_in_donex_cnts_s cn73xx;
	struct cvmx_sli_pkt_in_donex_cnts_s cn78xx;
	struct cvmx_sli_pkt_in_donex_cnts_cn78xxp1 {
		u64 po_int : 1;
		u64 pi_int : 1;
		u64 reserved_61_49 : 13;
		u64 cint_enb : 1;
		u64 wmark : 16;
		u64 cnt : 32;
	} cn78xxp1;
	struct cvmx_sli_pkt_in_donex_cnts_cn61xx cnf71xx;
	struct cvmx_sli_pkt_in_donex_cnts_s cnf75xx;
};

typedef union cvmx_sli_pkt_in_donex_cnts cvmx_sli_pkt_in_donex_cnts_t;

/**
 * cvmx_sli_pkt_in_instr_counts
 *
 * This register contains keeps track of the number of instructions read into the FIFO and
 * packets sent to PKI. This register is PF-only.
 */
union cvmx_sli_pkt_in_instr_counts {
	u64 u64;
	struct cvmx_sli_pkt_in_instr_counts_s {
		u64 wr_cnt : 32;
		u64 rd_cnt : 32;
	} s;
	struct cvmx_sli_pkt_in_instr_counts_s cn61xx;
	struct cvmx_sli_pkt_in_instr_counts_s cn63xx;
	struct cvmx_sli_pkt_in_instr_counts_s cn63xxp1;
	struct cvmx_sli_pkt_in_instr_counts_s cn66xx;
	struct cvmx_sli_pkt_in_instr_counts_s cn68xx;
	struct cvmx_sli_pkt_in_instr_counts_s cn68xxp1;
	struct cvmx_sli_pkt_in_instr_counts_s cn70xx;
	struct cvmx_sli_pkt_in_instr_counts_s cn70xxp1;
	struct cvmx_sli_pkt_in_instr_counts_s cn73xx;
	struct cvmx_sli_pkt_in_instr_counts_s cn78xx;
	struct cvmx_sli_pkt_in_instr_counts_s cn78xxp1;
	struct cvmx_sli_pkt_in_instr_counts_s cnf71xx;
	struct cvmx_sli_pkt_in_instr_counts_s cnf75xx;
};

typedef union cvmx_sli_pkt_in_instr_counts cvmx_sli_pkt_in_instr_counts_t;

/**
 * cvmx_sli_pkt_in_int
 *
 * This register specifies which input packets rings are interrupting because of done counts.
 * A bit set in this interrupt register will set a corresponding bit in SLI_PKT_INT which
 * can cause a MSI-X interrupt.  When read by a function, this register informs which rings
 * owned by the function (0 to N, N as large as 63) have this interrupt pending.
 * SLI_PKT_IN_INT conditions can cause MSI-X interrupts, but do not cause any
 * SLI_MAC()_PF()_INT_SUM
 * bit to set, and cannot cause INTA/B/C/D nor MSI interrupts.
 */
union cvmx_sli_pkt_in_int {
	u64 u64;
	struct cvmx_sli_pkt_in_int_s {
		u64 ring : 64;
	} s;
	struct cvmx_sli_pkt_in_int_s cn73xx;
	struct cvmx_sli_pkt_in_int_s cn78xx;
	struct cvmx_sli_pkt_in_int_s cn78xxp1;
	struct cvmx_sli_pkt_in_int_s cnf75xx;
};

typedef union cvmx_sli_pkt_in_int cvmx_sli_pkt_in_int_t;

/**
 * cvmx_sli_pkt_in_jabber
 *
 * Register to set limit on SLI packet input packet sizes.
 *
 */
union cvmx_sli_pkt_in_jabber {
	u64 u64;
	struct cvmx_sli_pkt_in_jabber_s {
		u64 reserved_32_63 : 32;
		u64 size : 32;
	} s;
	struct cvmx_sli_pkt_in_jabber_s cn73xx;
	struct cvmx_sli_pkt_in_jabber_s cn78xx;
	struct cvmx_sli_pkt_in_jabber_s cnf75xx;
};

typedef union cvmx_sli_pkt_in_jabber cvmx_sli_pkt_in_jabber_t;

/**
 * cvmx_sli_pkt_in_pcie_port
 *
 * Assigns Packet Input rings to MAC ports.
 *
 */
union cvmx_sli_pkt_in_pcie_port {
	u64 u64;
	struct cvmx_sli_pkt_in_pcie_port_s {
		u64 pp : 64;
	} s;
	struct cvmx_sli_pkt_in_pcie_port_s cn61xx;
	struct cvmx_sli_pkt_in_pcie_port_s cn63xx;
	struct cvmx_sli_pkt_in_pcie_port_s cn63xxp1;
	struct cvmx_sli_pkt_in_pcie_port_s cn66xx;
	struct cvmx_sli_pkt_in_pcie_port_s cn68xx;
	struct cvmx_sli_pkt_in_pcie_port_s cn68xxp1;
	struct cvmx_sli_pkt_in_pcie_port_s cn70xx;
	struct cvmx_sli_pkt_in_pcie_port_s cn70xxp1;
	struct cvmx_sli_pkt_in_pcie_port_s cnf71xx;
};

typedef union cvmx_sli_pkt_in_pcie_port cvmx_sli_pkt_in_pcie_port_t;

/**
 * cvmx_sli_pkt_input_control
 *
 * Control for reads for gather list and instructions.
 *
 */
union cvmx_sli_pkt_input_control {
	u64 u64;
	struct cvmx_sli_pkt_input_control_s {
		u64 prd_erst : 1;
		u64 prd_rds : 7;
		u64 gii_erst : 1;
		u64 gii_rds : 7;
		u64 reserved_41_47 : 7;
		u64 prc_idle : 1;
		u64 reserved_24_39 : 16;
		u64 pin_rst : 1;
		u64 pkt_rr : 1;
		u64 pbp_dhi : 13;
		u64 d_nsr : 1;
		u64 d_esr : 2;
		u64 d_ror : 1;
		u64 use_csr : 1;
		u64 nsr : 1;
		u64 esr : 2;
		u64 ror : 1;
	} s;
	struct cvmx_sli_pkt_input_control_s cn61xx;
	struct cvmx_sli_pkt_input_control_cn63xx {
		u64 reserved_23_63 : 41;
		u64 pkt_rr : 1;
		u64 pbp_dhi : 13;
		u64 d_nsr : 1;
		u64 d_esr : 2;
		u64 d_ror : 1;
		u64 use_csr : 1;
		u64 nsr : 1;
		u64 esr : 2;
		u64 ror : 1;
	} cn63xx;
	struct cvmx_sli_pkt_input_control_cn63xx cn63xxp1;
	struct cvmx_sli_pkt_input_control_s cn66xx;
	struct cvmx_sli_pkt_input_control_s cn68xx;
	struct cvmx_sli_pkt_input_control_s cn68xxp1;
	struct cvmx_sli_pkt_input_control_s cn70xx;
	struct cvmx_sli_pkt_input_control_s cn70xxp1;
	struct cvmx_sli_pkt_input_control_s cnf71xx;
};

typedef union cvmx_sli_pkt_input_control cvmx_sli_pkt_input_control_t;

/**
 * cvmx_sli_pkt_instr_enb
 *
 * Multi-ring instruction input enable register. This register is PF-only.
 *
 */
union cvmx_sli_pkt_instr_enb {
	u64 u64;
	struct cvmx_sli_pkt_instr_enb_s {
		u64 enb : 64;
	} s;
	struct cvmx_sli_pkt_instr_enb_cn61xx {
		u64 reserved_32_63 : 32;
		u64 enb : 32;
	} cn61xx;
	struct cvmx_sli_pkt_instr_enb_cn61xx cn63xx;
	struct cvmx_sli_pkt_instr_enb_cn61xx cn63xxp1;
	struct cvmx_sli_pkt_instr_enb_cn61xx cn66xx;
	struct cvmx_sli_pkt_instr_enb_cn61xx cn68xx;
	struct cvmx_sli_pkt_instr_enb_cn61xx cn68xxp1;
	struct cvmx_sli_pkt_instr_enb_cn61xx cn70xx;
	struct cvmx_sli_pkt_instr_enb_cn61xx cn70xxp1;
	struct cvmx_sli_pkt_instr_enb_s cn78xxp1;
	struct cvmx_sli_pkt_instr_enb_cn61xx cnf71xx;
};

typedef union cvmx_sli_pkt_instr_enb cvmx_sli_pkt_instr_enb_t;

/**
 * cvmx_sli_pkt_instr_rd_size
 *
 * The number of instruction allowed to be read at one time.
 *
 */
union cvmx_sli_pkt_instr_rd_size {
	u64 u64;
	struct cvmx_sli_pkt_instr_rd_size_s {
		u64 rdsize : 64;
	} s;
	struct cvmx_sli_pkt_instr_rd_size_s cn61xx;
	struct cvmx_sli_pkt_instr_rd_size_s cn63xx;
	struct cvmx_sli_pkt_instr_rd_size_s cn63xxp1;
	struct cvmx_sli_pkt_instr_rd_size_s cn66xx;
	struct cvmx_sli_pkt_instr_rd_size_s cn68xx;
	struct cvmx_sli_pkt_instr_rd_size_s cn68xxp1;
	struct cvmx_sli_pkt_instr_rd_size_s cn70xx;
	struct cvmx_sli_pkt_instr_rd_size_s cn70xxp1;
	struct cvmx_sli_pkt_instr_rd_size_s cnf71xx;
};

typedef union cvmx_sli_pkt_instr_rd_size cvmx_sli_pkt_instr_rd_size_t;

/**
 * cvmx_sli_pkt_instr_size
 *
 * Determines if instructions are 64 or 32 byte in size for a Packet-ring.
 *
 */
union cvmx_sli_pkt_instr_size {
	u64 u64;
	struct cvmx_sli_pkt_instr_size_s {
		u64 reserved_32_63 : 32;
		u64 is_64b : 32;
	} s;
	struct cvmx_sli_pkt_instr_size_s cn61xx;
	struct cvmx_sli_pkt_instr_size_s cn63xx;
	struct cvmx_sli_pkt_instr_size_s cn63xxp1;
	struct cvmx_sli_pkt_instr_size_s cn66xx;
	struct cvmx_sli_pkt_instr_size_s cn68xx;
	struct cvmx_sli_pkt_instr_size_s cn68xxp1;
	struct cvmx_sli_pkt_instr_size_s cn70xx;
	struct cvmx_sli_pkt_instr_size_s cn70xxp1;
	struct cvmx_sli_pkt_instr_size_s cnf71xx;
};

typedef union cvmx_sli_pkt_instr_size cvmx_sli_pkt_instr_size_t;

/**
 * cvmx_sli_pkt_int
 *
 * This register combines the SLI_PKT_CNT_INT, SLI_PKT_TIME_INT or SLI_PKT_IN_INT interrupt
 * registers. When read by a function, this register informs which rings owned by the function
 * (0 to N, N as large as 63) have an interrupt pending.
 */
union cvmx_sli_pkt_int {
	u64 u64;
	struct cvmx_sli_pkt_int_s {
		u64 ring : 64;
	} s;
	struct cvmx_sli_pkt_int_s cn73xx;
	struct cvmx_sli_pkt_int_s cn78xx;
	struct cvmx_sli_pkt_int_s cn78xxp1;
	struct cvmx_sli_pkt_int_s cnf75xx;
};

typedef union cvmx_sli_pkt_int cvmx_sli_pkt_int_t;

/**
 * cvmx_sli_pkt_int_levels
 *
 * SLI_PKT_INT_LEVELS = SLI's Packet Interrupt Levels
 * Output packet interrupt levels.
 */
union cvmx_sli_pkt_int_levels {
	u64 u64;
	struct cvmx_sli_pkt_int_levels_s {
		u64 reserved_54_63 : 10;
		u64 time : 22;
		u64 cnt : 32;
	} s;
	struct cvmx_sli_pkt_int_levels_s cn61xx;
	struct cvmx_sli_pkt_int_levels_s cn63xx;
	struct cvmx_sli_pkt_int_levels_s cn63xxp1;
	struct cvmx_sli_pkt_int_levels_s cn66xx;
	struct cvmx_sli_pkt_int_levels_s cn68xx;
	struct cvmx_sli_pkt_int_levels_s cn68xxp1;
	struct cvmx_sli_pkt_int_levels_s cn70xx;
	struct cvmx_sli_pkt_int_levels_s cn70xxp1;
	struct cvmx_sli_pkt_int_levels_s cnf71xx;
};

typedef union cvmx_sli_pkt_int_levels cvmx_sli_pkt_int_levels_t;

/**
 * cvmx_sli_pkt_iptr
 *
 * Controls using the Info-Pointer to store length and data.
 *
 */
union cvmx_sli_pkt_iptr {
	u64 u64;
	struct cvmx_sli_pkt_iptr_s {
		u64 reserved_32_63 : 32;
		u64 iptr : 32;
	} s;
	struct cvmx_sli_pkt_iptr_s cn61xx;
	struct cvmx_sli_pkt_iptr_s cn63xx;
	struct cvmx_sli_pkt_iptr_s cn63xxp1;
	struct cvmx_sli_pkt_iptr_s cn66xx;
	struct cvmx_sli_pkt_iptr_s cn68xx;
	struct cvmx_sli_pkt_iptr_s cn68xxp1;
	struct cvmx_sli_pkt_iptr_s cn70xx;
	struct cvmx_sli_pkt_iptr_s cn70xxp1;
	struct cvmx_sli_pkt_iptr_s cnf71xx;
};

typedef union cvmx_sli_pkt_iptr cvmx_sli_pkt_iptr_t;

/**
 * cvmx_sli_pkt_mac#_pf#_rinfo
 *
 * This register sets the total number and starting number of rings for a given MAC and PF
 * combination. Indexed by (MAC index) SLI_PORT_E. In SR-IOV mode, SLI_PKT_MAC()_PF()_RINFO[RPVF]
 * and SLI_PKT_MAC()_PF()_RINFO[NVFS] must be non zero and determine which rings the PFs and
 * VFs own.
 *
 * An individual VF will own SLI_PKT_MAC()_PF()_RINFO[RPVF] number of rings.
 *
 * A PF will own the rings starting from ((SLI_PKT_MAC()_PF()_RINFO[SRN] +
 * (SLI_PKT_MAC()_PF()_RINFO[RPVF] * SLI_PKT_MAC()_PF()_RINFO[NVFS]))
 * to (SLI_PKT_MAC()_PF()_RINFO[SRN] + (SLI_PKT_MAC()_PF()_RINFO[TRS] -
 * 1)). SLI_PKT()_INPUT_CONTROL[PVF_NUM] must be written to values that
 * correlate with the fields in this register.
 *
 * e.g. Given:
 * _ SLI_PKT_MAC0_PF0_RINFO[SRN] = 32,
 * _ SLI_PKT_MAC0_PF0_RINFO[TRS] = 32,
 * _ SLI_PKT_MAC0_PF0_RINFO[RPVF] = 4,
 * _ SLI_PKT_MAC0_PF0_RINFO[NVFS] = 7:
 * _ rings owned by VF1: 32,33,34,35
 * _ rings owned by VF2: 36,37,38,39
 * _ rings owned by VF3: 40,41,42,43
 * _ rings owned by VF4: 44,45,46,47
 * _ rings owned by VF5: 48,49,50,51
 * _ rings owned by VF6: 52,53,54,55
 * _ rings owned by VF7: 56,57,58,59
 * _ rings owned by PF:  60,61,62,63
 */
union cvmx_sli_pkt_macx_pfx_rinfo {
	u64 u64;
	struct cvmx_sli_pkt_macx_pfx_rinfo_s {
		u64 reserved_55_63 : 9;
		u64 nvfs : 7;
		u64 reserved_40_47 : 8;
		u64 rpvf : 8;
		u64 reserved_24_31 : 8;
		u64 trs : 8;
		u64 reserved_7_15 : 9;
		u64 srn : 7;
	} s;
	struct cvmx_sli_pkt_macx_pfx_rinfo_s cn73xx;
	struct cvmx_sli_pkt_macx_pfx_rinfo_s cn78xx;
	struct cvmx_sli_pkt_macx_pfx_rinfo_s cnf75xx;
};

typedef union cvmx_sli_pkt_macx_pfx_rinfo cvmx_sli_pkt_macx_pfx_rinfo_t;

/**
 * cvmx_sli_pkt_mac#_rinfo
 *
 * This register sets the total number and starting number of rings used by the MAC.
 * This register is PF-only.
 */
union cvmx_sli_pkt_macx_rinfo {
	u64 u64;
	struct cvmx_sli_pkt_macx_rinfo_s {
		u64 reserved_40_63 : 24;
		u64 rpvf : 8;
		u64 reserved_24_31 : 8;
		u64 trs : 8;
		u64 reserved_7_15 : 9;
		u64 srn : 7;
	} s;
	struct cvmx_sli_pkt_macx_rinfo_s cn78xxp1;
};

typedef union cvmx_sli_pkt_macx_rinfo cvmx_sli_pkt_macx_rinfo_t;

/**
 * cvmx_sli_pkt_mac0_sig0
 *
 * This register is used to signal between PF/VF. This register can be R/W by the PF from MAC0
 * and any VF.
 */
union cvmx_sli_pkt_mac0_sig0 {
	u64 u64;
	struct cvmx_sli_pkt_mac0_sig0_s {
		u64 data : 64;
	} s;
	struct cvmx_sli_pkt_mac0_sig0_s cn78xxp1;
};

typedef union cvmx_sli_pkt_mac0_sig0 cvmx_sli_pkt_mac0_sig0_t;

/**
 * cvmx_sli_pkt_mac0_sig1
 *
 * This register is used to signal between PF/VF. This register can be R/W by the PF from MAC0
 * and any VF.
 */
union cvmx_sli_pkt_mac0_sig1 {
	u64 u64;
	struct cvmx_sli_pkt_mac0_sig1_s {
		u64 data : 64;
	} s;
	struct cvmx_sli_pkt_mac0_sig1_s cn78xxp1;
};

typedef union cvmx_sli_pkt_mac0_sig1 cvmx_sli_pkt_mac0_sig1_t;

/**
 * cvmx_sli_pkt_mac1_sig0
 *
 * This register is used to signal between PF/VF. This register can be R/W by the PF from MAC1
 * and any VF.
 */
union cvmx_sli_pkt_mac1_sig0 {
	u64 u64;
	struct cvmx_sli_pkt_mac1_sig0_s {
		u64 data : 64;
	} s;
	struct cvmx_sli_pkt_mac1_sig0_s cn78xxp1;
};

typedef union cvmx_sli_pkt_mac1_sig0 cvmx_sli_pkt_mac1_sig0_t;

/**
 * cvmx_sli_pkt_mac1_sig1
 *
 * This register is used to signal between PF/VF. This register can be R/W by the PF from MAC1
 * and any VF.
 */
union cvmx_sli_pkt_mac1_sig1 {
	u64 u64;
	struct cvmx_sli_pkt_mac1_sig1_s {
		u64 data : 64;
	} s;
	struct cvmx_sli_pkt_mac1_sig1_s cn78xxp1;
};

typedef union cvmx_sli_pkt_mac1_sig1 cvmx_sli_pkt_mac1_sig1_t;

/**
 * cvmx_sli_pkt_mem_ctl
 *
 * This register controls the ECC of the SLI packet memories.
 *
 */
union cvmx_sli_pkt_mem_ctl {
	u64 u64;
	struct cvmx_sli_pkt_mem_ctl_s {
		u64 reserved_48_63 : 16;
		u64 msix_mbox_fs : 2;
		u64 msix_mbox_ecc : 1;
		u64 reserved_36_44 : 9;
		u64 pos_fs : 2;
		u64 pos_ecc : 1;
		u64 pinm_fs : 2;
		u64 pinm_ecc : 1;
		u64 pind_fs : 2;
		u64 pind_ecc : 1;
		u64 point_fs : 2;
		u64 point_ecc : 1;
		u64 slist_fs : 2;
		u64 slist_ecc : 1;
		u64 pop1_fs : 2;
		u64 pop1_ecc : 1;
		u64 pop0_fs : 2;
		u64 pop0_ecc : 1;
		u64 pfp_fs : 2;
		u64 pfp_ecc : 1;
		u64 pbn_fs : 2;
		u64 pbn_ecc : 1;
		u64 pdf_fs : 2;
		u64 pdf_ecc : 1;
		u64 psf_fs : 2;
		u64 psf_ecc : 1;
		u64 poi_fs : 2;
		u64 poi_ecc : 1;
	} s;
	struct cvmx_sli_pkt_mem_ctl_cn73xx {
		u64 reserved_48_63 : 16;
		u64 msix_mbox_fs : 2;
		u64 msix_mbox_ecc : 1;
		u64 msix_data_fs : 2;
		u64 msix_data_ecc : 1;
		u64 msix_addr_fs : 2;
		u64 msix_addr_ecc : 1;
		u64 pof_fs : 2;
		u64 pof_ecc : 1;
		u64 pos_fs : 2;
		u64 pos_ecc : 1;
		u64 pinm_fs : 2;
		u64 pinm_ecc : 1;
		u64 pind_fs : 2;
		u64 pind_ecc : 1;
		u64 point_fs : 2;
		u64 point_ecc : 1;
		u64 slist_fs : 2;
		u64 slist_ecc : 1;
		u64 pop1_fs : 2;
		u64 pop1_ecc : 1;
		u64 pop0_fs : 2;
		u64 pop0_ecc : 1;
		u64 pfp_fs : 2;
		u64 pfp_ecc : 1;
		u64 pbn_fs : 2;
		u64 pbn_ecc : 1;
		u64 pdf_fs : 2;
		u64 pdf_ecc : 1;
		u64 psf_fs : 2;
		u64 psf_ecc : 1;
		u64 poi_fs : 2;
		u64 poi_ecc : 1;
	} cn73xx;
	struct cvmx_sli_pkt_mem_ctl_cn73xx cn78xx;
	struct cvmx_sli_pkt_mem_ctl_cn78xxp1 {
		u64 reserved_44_63 : 20;
		u64 msid_fs : 2;
		u64 msia_fs : 2;
		u64 msi_ecc : 1;
		u64 posi_fs : 2;
		u64 posi_ecc : 1;
		u64 pos_fs : 2;
		u64 pos_ecc : 1;
		u64 pinm_fs : 2;
		u64 pinm_ecc : 1;
		u64 pind_fs : 2;
		u64 pind_ecc : 1;
		u64 point_fs : 2;
		u64 point_ecc : 1;
		u64 slist_fs : 2;
		u64 slist_ecc : 1;
		u64 pop1_fs : 2;
		u64 pop1_ecc : 1;
		u64 pop0_fs : 2;
		u64 pop0_ecc : 1;
		u64 pfp_fs : 2;
		u64 pfp_ecc : 1;
		u64 pbn_fs : 2;
		u64 pbn_ecc : 1;
		u64 pdf_fs : 2;
		u64 pdf_ecc : 1;
		u64 psf_fs : 2;
		u64 psf_ecc : 1;
		u64 poi_fs : 2;
		u64 poi_ecc : 1;
	} cn78xxp1;
	struct cvmx_sli_pkt_mem_ctl_cn73xx cnf75xx;
};

typedef union cvmx_sli_pkt_mem_ctl cvmx_sli_pkt_mem_ctl_t;

/**
 * cvmx_sli_pkt_out_bmode
 *
 * Control the updating of the SLI_PKT#_CNT register.
 *
 */
union cvmx_sli_pkt_out_bmode {
	u64 u64;
	struct cvmx_sli_pkt_out_bmode_s {
		u64 reserved_32_63 : 32;
		u64 bmode : 32;
	} s;
	struct cvmx_sli_pkt_out_bmode_s cn61xx;
	struct cvmx_sli_pkt_out_bmode_s cn63xx;
	struct cvmx_sli_pkt_out_bmode_s cn63xxp1;
	struct cvmx_sli_pkt_out_bmode_s cn66xx;
	struct cvmx_sli_pkt_out_bmode_s cn68xx;
	struct cvmx_sli_pkt_out_bmode_s cn68xxp1;
	struct cvmx_sli_pkt_out_bmode_s cn70xx;
	struct cvmx_sli_pkt_out_bmode_s cn70xxp1;
	struct cvmx_sli_pkt_out_bmode_s cnf71xx;
};

typedef union cvmx_sli_pkt_out_bmode cvmx_sli_pkt_out_bmode_t;

/**
 * cvmx_sli_pkt_out_bp_en
 *
 * This register enables sending backpressure to PKO.
 *
 */
union cvmx_sli_pkt_out_bp_en {
	u64 u64;
	struct cvmx_sli_pkt_out_bp_en_s {
		u64 bp_en : 64;
	} s;
	struct cvmx_sli_pkt_out_bp_en_cn68xx {
		u64 reserved_32_63 : 32;
		u64 bp_en : 32;
	} cn68xx;
	struct cvmx_sli_pkt_out_bp_en_cn68xx cn68xxp1;
	struct cvmx_sli_pkt_out_bp_en_s cn78xxp1;
};

typedef union cvmx_sli_pkt_out_bp_en cvmx_sli_pkt_out_bp_en_t;

/**
 * cvmx_sli_pkt_out_bp_en2_w1c
 *
 * This register disables sending backpressure to PKO.
 *
 */
union cvmx_sli_pkt_out_bp_en2_w1c {
	u64 u64;
	struct cvmx_sli_pkt_out_bp_en2_w1c_s {
		u64 w1c : 64;
	} s;
	struct cvmx_sli_pkt_out_bp_en2_w1c_s cn73xx;
};

typedef union cvmx_sli_pkt_out_bp_en2_w1c cvmx_sli_pkt_out_bp_en2_w1c_t;

/**
 * cvmx_sli_pkt_out_bp_en2_w1s
 *
 * This register enables sending backpressure to PKO.
 *
 */
union cvmx_sli_pkt_out_bp_en2_w1s {
	u64 u64;
	struct cvmx_sli_pkt_out_bp_en2_w1s_s {
		u64 w1s : 64;
	} s;
	struct cvmx_sli_pkt_out_bp_en2_w1s_s cn73xx;
};

typedef union cvmx_sli_pkt_out_bp_en2_w1s cvmx_sli_pkt_out_bp_en2_w1s_t;

/**
 * cvmx_sli_pkt_out_bp_en_w1c
 *
 * This register disables sending backpressure to PKO.
 *
 */
union cvmx_sli_pkt_out_bp_en_w1c {
	u64 u64;
	struct cvmx_sli_pkt_out_bp_en_w1c_s {
		u64 w1c : 64;
	} s;
	struct cvmx_sli_pkt_out_bp_en_w1c_s cn73xx;
	struct cvmx_sli_pkt_out_bp_en_w1c_s cn78xx;
	struct cvmx_sli_pkt_out_bp_en_w1c_s cnf75xx;
};

typedef union cvmx_sli_pkt_out_bp_en_w1c cvmx_sli_pkt_out_bp_en_w1c_t;

/**
 * cvmx_sli_pkt_out_bp_en_w1s
 *
 * This register enables sending backpressure to PKO.
 *
 */
union cvmx_sli_pkt_out_bp_en_w1s {
	u64 u64;
	struct cvmx_sli_pkt_out_bp_en_w1s_s {
		u64 w1s : 64;
	} s;
	struct cvmx_sli_pkt_out_bp_en_w1s_s cn73xx;
	struct cvmx_sli_pkt_out_bp_en_w1s_s cn78xx;
	struct cvmx_sli_pkt_out_bp_en_w1s_s cnf75xx;
};

typedef union cvmx_sli_pkt_out_bp_en_w1s cvmx_sli_pkt_out_bp_en_w1s_t;

/**
 * cvmx_sli_pkt_out_enb
 *
 * Multi-ring packet output enable register. This register is PF-only.
 *
 */
union cvmx_sli_pkt_out_enb {
	u64 u64;
	struct cvmx_sli_pkt_out_enb_s {
		u64 enb : 64;
	} s;
	struct cvmx_sli_pkt_out_enb_cn61xx {
		u64 reserved_32_63 : 32;
		u64 enb : 32;
	} cn61xx;
	struct cvmx_sli_pkt_out_enb_cn61xx cn63xx;
	struct cvmx_sli_pkt_out_enb_cn61xx cn63xxp1;
	struct cvmx_sli_pkt_out_enb_cn61xx cn66xx;
	struct cvmx_sli_pkt_out_enb_cn61xx cn68xx;
	struct cvmx_sli_pkt_out_enb_cn61xx cn68xxp1;
	struct cvmx_sli_pkt_out_enb_cn61xx cn70xx;
	struct cvmx_sli_pkt_out_enb_cn61xx cn70xxp1;
	struct cvmx_sli_pkt_out_enb_s cn78xxp1;
	struct cvmx_sli_pkt_out_enb_cn61xx cnf71xx;
};

typedef union cvmx_sli_pkt_out_enb cvmx_sli_pkt_out_enb_t;

/**
 * cvmx_sli_pkt_output_wmark
 *
 * This register sets the value that determines when backpressure is applied to the PKO. When
 * SLI_PKT()_SLIST_BAOFF_DBELL[DBELL] is less than [WMARK], backpressure is sent to PKO for
 * the associated channel. This register is PF-only.
 */
union cvmx_sli_pkt_output_wmark {
	u64 u64;
	struct cvmx_sli_pkt_output_wmark_s {
		u64 reserved_32_63 : 32;
		u64 wmark : 32;
	} s;
	struct cvmx_sli_pkt_output_wmark_s cn61xx;
	struct cvmx_sli_pkt_output_wmark_s cn63xx;
	struct cvmx_sli_pkt_output_wmark_s cn63xxp1;
	struct cvmx_sli_pkt_output_wmark_s cn66xx;
	struct cvmx_sli_pkt_output_wmark_s cn68xx;
	struct cvmx_sli_pkt_output_wmark_s cn68xxp1;
	struct cvmx_sli_pkt_output_wmark_s cn70xx;
	struct cvmx_sli_pkt_output_wmark_s cn70xxp1;
	struct cvmx_sli_pkt_output_wmark_s cn73xx;
	struct cvmx_sli_pkt_output_wmark_s cn78xx;
	struct cvmx_sli_pkt_output_wmark_s cn78xxp1;
	struct cvmx_sli_pkt_output_wmark_s cnf71xx;
	struct cvmx_sli_pkt_output_wmark_s cnf75xx;
};

typedef union cvmx_sli_pkt_output_wmark cvmx_sli_pkt_output_wmark_t;

/**
 * cvmx_sli_pkt_pcie_port
 *
 * Assigns Packet Ports to MAC ports.
 *
 */
union cvmx_sli_pkt_pcie_port {
	u64 u64;
	struct cvmx_sli_pkt_pcie_port_s {
		u64 pp : 64;
	} s;
	struct cvmx_sli_pkt_pcie_port_s cn61xx;
	struct cvmx_sli_pkt_pcie_port_s cn63xx;
	struct cvmx_sli_pkt_pcie_port_s cn63xxp1;
	struct cvmx_sli_pkt_pcie_port_s cn66xx;
	struct cvmx_sli_pkt_pcie_port_s cn68xx;
	struct cvmx_sli_pkt_pcie_port_s cn68xxp1;
	struct cvmx_sli_pkt_pcie_port_s cn70xx;
	struct cvmx_sli_pkt_pcie_port_s cn70xxp1;
	struct cvmx_sli_pkt_pcie_port_s cnf71xx;
};

typedef union cvmx_sli_pkt_pcie_port cvmx_sli_pkt_pcie_port_t;

/**
 * cvmx_sli_pkt_pkind_valid
 *
 * Enables bits per PKIND that are allowed to be sent to PKI specified in the
 * DPI_PKT_INST_HDR_S[PKIND] DPI packet instruction field.
 */
union cvmx_sli_pkt_pkind_valid {
	u64 u64;
	struct cvmx_sli_pkt_pkind_valid_s {
		u64 enb : 64;
	} s;
	struct cvmx_sli_pkt_pkind_valid_s cn73xx;
	struct cvmx_sli_pkt_pkind_valid_s cn78xx;
	struct cvmx_sli_pkt_pkind_valid_s cnf75xx;
};

typedef union cvmx_sli_pkt_pkind_valid cvmx_sli_pkt_pkind_valid_t;

/**
 * cvmx_sli_pkt_port_in_rst
 *
 * SLI_PKT_PORT_IN_RST = SLI Packet Port In Reset
 * Vector bits related to ring-port for ones that are reset.
 */
union cvmx_sli_pkt_port_in_rst {
	u64 u64;
	struct cvmx_sli_pkt_port_in_rst_s {
		u64 in_rst : 32;
		u64 out_rst : 32;
	} s;
	struct cvmx_sli_pkt_port_in_rst_s cn61xx;
	struct cvmx_sli_pkt_port_in_rst_s cn63xx;
	struct cvmx_sli_pkt_port_in_rst_s cn63xxp1;
	struct cvmx_sli_pkt_port_in_rst_s cn66xx;
	struct cvmx_sli_pkt_port_in_rst_s cn68xx;
	struct cvmx_sli_pkt_port_in_rst_s cn68xxp1;
	struct cvmx_sli_pkt_port_in_rst_s cn70xx;
	struct cvmx_sli_pkt_port_in_rst_s cn70xxp1;
	struct cvmx_sli_pkt_port_in_rst_s cnf71xx;
};

typedef union cvmx_sli_pkt_port_in_rst cvmx_sli_pkt_port_in_rst_t;

/**
 * cvmx_sli_pkt_ring_rst
 *
 * When read by a PF, this register informs which rings owned by the function (0 to N, N as large
 * as 63) are in reset. See also SLI_PKT()_INPUT_CONTROL[RST].
 */
union cvmx_sli_pkt_ring_rst {
	u64 u64;
	struct cvmx_sli_pkt_ring_rst_s {
		u64 rst : 64;
	} s;
	struct cvmx_sli_pkt_ring_rst_s cn73xx;
	struct cvmx_sli_pkt_ring_rst_s cn78xx;
	struct cvmx_sli_pkt_ring_rst_s cn78xxp1;
	struct cvmx_sli_pkt_ring_rst_s cnf75xx;
};

typedef union cvmx_sli_pkt_ring_rst cvmx_sli_pkt_ring_rst_t;

/**
 * cvmx_sli_pkt_slist_es
 *
 * The Endian Swap for Scatter List Read.
 *
 */
union cvmx_sli_pkt_slist_es {
	u64 u64;
	struct cvmx_sli_pkt_slist_es_s {
		u64 es : 64;
	} s;
	struct cvmx_sli_pkt_slist_es_s cn61xx;
	struct cvmx_sli_pkt_slist_es_s cn63xx;
	struct cvmx_sli_pkt_slist_es_s cn63xxp1;
	struct cvmx_sli_pkt_slist_es_s cn66xx;
	struct cvmx_sli_pkt_slist_es_s cn68xx;
	struct cvmx_sli_pkt_slist_es_s cn68xxp1;
	struct cvmx_sli_pkt_slist_es_s cn70xx;
	struct cvmx_sli_pkt_slist_es_s cn70xxp1;
	struct cvmx_sli_pkt_slist_es_s cnf71xx;
};

typedef union cvmx_sli_pkt_slist_es cvmx_sli_pkt_slist_es_t;

/**
 * cvmx_sli_pkt_slist_ns
 *
 * The NS field for the TLP when fetching Scatter List.
 *
 */
union cvmx_sli_pkt_slist_ns {
	u64 u64;
	struct cvmx_sli_pkt_slist_ns_s {
		u64 reserved_32_63 : 32;
		u64 nsr : 32;
	} s;
	struct cvmx_sli_pkt_slist_ns_s cn61xx;
	struct cvmx_sli_pkt_slist_ns_s cn63xx;
	struct cvmx_sli_pkt_slist_ns_s cn63xxp1;
	struct cvmx_sli_pkt_slist_ns_s cn66xx;
	struct cvmx_sli_pkt_slist_ns_s cn68xx;
	struct cvmx_sli_pkt_slist_ns_s cn68xxp1;
	struct cvmx_sli_pkt_slist_ns_s cn70xx;
	struct cvmx_sli_pkt_slist_ns_s cn70xxp1;
	struct cvmx_sli_pkt_slist_ns_s cnf71xx;
};

typedef union cvmx_sli_pkt_slist_ns cvmx_sli_pkt_slist_ns_t;

/**
 * cvmx_sli_pkt_slist_ror
 *
 * The ROR field for the TLP when fetching Scatter List.
 *
 */
union cvmx_sli_pkt_slist_ror {
	u64 u64;
	struct cvmx_sli_pkt_slist_ror_s {
		u64 reserved_32_63 : 32;
		u64 ror : 32;
	} s;
	struct cvmx_sli_pkt_slist_ror_s cn61xx;
	struct cvmx_sli_pkt_slist_ror_s cn63xx;
	struct cvmx_sli_pkt_slist_ror_s cn63xxp1;
	struct cvmx_sli_pkt_slist_ror_s cn66xx;
	struct cvmx_sli_pkt_slist_ror_s cn68xx;
	struct cvmx_sli_pkt_slist_ror_s cn68xxp1;
	struct cvmx_sli_pkt_slist_ror_s cn70xx;
	struct cvmx_sli_pkt_slist_ror_s cn70xxp1;
	struct cvmx_sli_pkt_slist_ror_s cnf71xx;
};

typedef union cvmx_sli_pkt_slist_ror cvmx_sli_pkt_slist_ror_t;

/**
 * cvmx_sli_pkt_time_int
 *
 * This register specifies which output packets rings are interrupting because of packet timers.
 * A bit set in this interrupt register will set a corresponding bit in SLI_PKT_INT and can
 * also cause SLI_MAC()_PF()_INT_SUM[PTIME] to be set if
 * SLI_PKT()_OUTPUT_CONTROL[TENB]
 * is set. When read by a function, this register informs which rings owned by the function (0 to
 * N,
 * N as large as 63) have this interrupt pending.
 */
union cvmx_sli_pkt_time_int {
	u64 u64;
	struct cvmx_sli_pkt_time_int_s {
		u64 reserved_0_63 : 64;
	} s;
	struct cvmx_sli_pkt_time_int_cn61xx {
		u64 reserved_32_63 : 32;
		u64 port : 32;
	} cn61xx;
	struct cvmx_sli_pkt_time_int_cn61xx cn63xx;
	struct cvmx_sli_pkt_time_int_cn61xx cn63xxp1;
	struct cvmx_sli_pkt_time_int_cn61xx cn66xx;
	struct cvmx_sli_pkt_time_int_cn61xx cn68xx;
	struct cvmx_sli_pkt_time_int_cn61xx cn68xxp1;
	struct cvmx_sli_pkt_time_int_cn61xx cn70xx;
	struct cvmx_sli_pkt_time_int_cn61xx cn70xxp1;
	struct cvmx_sli_pkt_time_int_cn73xx {
		u64 ring : 64;
	} cn73xx;
	struct cvmx_sli_pkt_time_int_cn73xx cn78xx;
	struct cvmx_sli_pkt_time_int_cn73xx cn78xxp1;
	struct cvmx_sli_pkt_time_int_cn61xx cnf71xx;
	struct cvmx_sli_pkt_time_int_cn73xx cnf75xx;
};

typedef union cvmx_sli_pkt_time_int cvmx_sli_pkt_time_int_t;

/**
 * cvmx_sli_pkt_time_int_enb
 *
 * The packets rings that are interrupting because of Packet Timers.
 *
 */
union cvmx_sli_pkt_time_int_enb {
	u64 u64;
	struct cvmx_sli_pkt_time_int_enb_s {
		u64 reserved_32_63 : 32;
		u64 port : 32;
	} s;
	struct cvmx_sli_pkt_time_int_enb_s cn61xx;
	struct cvmx_sli_pkt_time_int_enb_s cn63xx;
	struct cvmx_sli_pkt_time_int_enb_s cn63xxp1;
	struct cvmx_sli_pkt_time_int_enb_s cn66xx;
	struct cvmx_sli_pkt_time_int_enb_s cn68xx;
	struct cvmx_sli_pkt_time_int_enb_s cn68xxp1;
	struct cvmx_sli_pkt_time_int_enb_s cn70xx;
	struct cvmx_sli_pkt_time_int_enb_s cn70xxp1;
	struct cvmx_sli_pkt_time_int_enb_s cnf71xx;
};

typedef union cvmx_sli_pkt_time_int_enb cvmx_sli_pkt_time_int_enb_t;

/**
 * cvmx_sli_port#_pkind
 *
 * SLI_PORT[0..31]_PKIND = SLI Port Pkind
 *
 * The SLI/DPI supports 32 input rings for fetching input packets. This register maps the input-rings (0-31) to a PKIND.
 */
union cvmx_sli_portx_pkind {
	u64 u64;
	struct cvmx_sli_portx_pkind_s {
		u64 reserved_25_63 : 39;
		u64 rpk_enb : 1;
		u64 reserved_22_23 : 2;
		u64 pkindr : 6;
		u64 reserved_14_15 : 2;
		u64 bpkind : 6;
		u64 reserved_6_7 : 2;
		u64 pkind : 6;
	} s;
	struct cvmx_sli_portx_pkind_s cn68xx;
	struct cvmx_sli_portx_pkind_cn68xxp1 {
		u64 reserved_14_63 : 50;
		u64 bpkind : 6;
		u64 reserved_6_7 : 2;
		u64 pkind : 6;
	} cn68xxp1;
};

typedef union cvmx_sli_portx_pkind cvmx_sli_portx_pkind_t;

/**
 * cvmx_sli_pp_pkt_csr_control
 *
 * This register provides access to SLI packet register space from the cores.
 * These SLI packet registers include the following:
 *  SLI_MSIXX_TABLE_ADDR,
 *  SLI_MSIXX_TABLE_DATA,
 *  SLI_MSIX_PBA0,
 *  SLI_MSIX_PBA1,
 *  SLI_PKTX_INPUT_CONTROL,
 *  SLI_PKTX_INSTR_BADDR,
 *  SLI_PKTX_INSTR_BAOFF_DBELL,
 *  SLI_PKTX_INSTR_FIFO_RSIZE,
 *  SLI_PKT_IN_DONEX_CNTS,
 *  SLI_PKTX_OUTPUT_CONTROL,
 *  SLI_PKTX_OUT_SIZE,
 *  SLI_PKTX_SLIST_BADDR,
 *  SLI_PKTX_SLIST_BAOFF_DBELL,
 *  SLI_PKTX_SLIST_FIFO_RSIZE,
 *  SLI_PKTX_INT_LEVELS,
 *  SLI_PKTX_CNTS,
 *  SLI_PKTX_ERROR_INFO,
 *  SLI_PKTX_VF_INT_SUM,
 *  SLI_PKTX_PF_VF_MBOX_SIG,
 *  SLI_PKTX_MBOX_INT.
 */
union cvmx_sli_pp_pkt_csr_control {
	u64 u64;
	struct cvmx_sli_pp_pkt_csr_control_s {
		u64 reserved_18_63 : 46;
		u64 mac : 2;
		u64 pvf : 16;
	} s;
	struct cvmx_sli_pp_pkt_csr_control_s cn73xx;
	struct cvmx_sli_pp_pkt_csr_control_s cn78xx;
	struct cvmx_sli_pp_pkt_csr_control_s cnf75xx;
};

typedef union cvmx_sli_pp_pkt_csr_control cvmx_sli_pp_pkt_csr_control_t;

/**
 * cvmx_sli_s2c_end_merge
 *
 * Writing this register will cause a merge to end.
 *
 */
union cvmx_sli_s2c_end_merge {
	u64 u64;
	struct cvmx_sli_s2c_end_merge_s {
		u64 reserved_0_63 : 64;
	} s;
	struct cvmx_sli_s2c_end_merge_s cn73xx;
	struct cvmx_sli_s2c_end_merge_s cn78xx;
	struct cvmx_sli_s2c_end_merge_s cn78xxp1;
	struct cvmx_sli_s2c_end_merge_s cnf75xx;
};

typedef union cvmx_sli_s2c_end_merge cvmx_sli_s2c_end_merge_t;

/**
 * cvmx_sli_s2m_port#_ctl
 *
 * These registers contain control for access from SLI to a MAC port. Indexed by SLI_PORT_E.
 * Write operations to these registers are not ordered with write/read operations to the MAC
 * memory space. To ensure that a write operation has completed, read the register before
 * making an access (i.e. MAC memory space) that requires the value of this register to be
 * updated.
 */
union cvmx_sli_s2m_portx_ctl {
	u64 u64;
	struct cvmx_sli_s2m_portx_ctl_s {
		u64 reserved_7_63 : 57;
		u64 dvferr : 1;
		u64 lcl_node : 1;
		u64 wind_d : 1;
		u64 bar0_d : 1;
		u64 reserved_0_2 : 3;
	} s;
	struct cvmx_sli_s2m_portx_ctl_cn61xx {
		u64 reserved_5_63 : 59;
		u64 wind_d : 1;
		u64 bar0_d : 1;
		u64 mrrs : 3;
	} cn61xx;
	struct cvmx_sli_s2m_portx_ctl_cn61xx cn63xx;
	struct cvmx_sli_s2m_portx_ctl_cn61xx cn63xxp1;
	struct cvmx_sli_s2m_portx_ctl_cn61xx cn66xx;
	struct cvmx_sli_s2m_portx_ctl_cn61xx cn68xx;
	struct cvmx_sli_s2m_portx_ctl_cn61xx cn68xxp1;
	struct cvmx_sli_s2m_portx_ctl_cn61xx cn70xx;
	struct cvmx_sli_s2m_portx_ctl_cn61xx cn70xxp1;
	struct cvmx_sli_s2m_portx_ctl_cn73xx {
		u64 reserved_7_63 : 57;
		u64 dvferr : 1;
		u64 lcl_node : 1;
		u64 wind_d : 1;
		u64 bar0_d : 1;
		u64 ld_cmd : 2;
		u64 reserved_0_0 : 1;
	} cn73xx;
	struct cvmx_sli_s2m_portx_ctl_cn73xx cn78xx;
	struct cvmx_sli_s2m_portx_ctl_cn78xxp1 {
		u64 reserved_6_63 : 58;
		u64 lcl_node : 1;
		u64 wind_d : 1;
		u64 bar0_d : 1;
		u64 ld_cmd : 2;
		u64 reserved_0_0 : 1;
	} cn78xxp1;
	struct cvmx_sli_s2m_portx_ctl_cn61xx cnf71xx;
	struct cvmx_sli_s2m_portx_ctl_cn73xx cnf75xx;
};

typedef union cvmx_sli_s2m_portx_ctl cvmx_sli_s2m_portx_ctl_t;

/**
 * cvmx_sli_scratch_1
 *
 * This registers is a general purpose 64-bit scratch register for software use.
 *
 */
union cvmx_sli_scratch_1 {
	u64 u64;
	struct cvmx_sli_scratch_1_s {
		u64 data : 64;
	} s;
	struct cvmx_sli_scratch_1_s cn61xx;
	struct cvmx_sli_scratch_1_s cn63xx;
	struct cvmx_sli_scratch_1_s cn63xxp1;
	struct cvmx_sli_scratch_1_s cn66xx;
	struct cvmx_sli_scratch_1_s cn68xx;
	struct cvmx_sli_scratch_1_s cn68xxp1;
	struct cvmx_sli_scratch_1_s cn70xx;
	struct cvmx_sli_scratch_1_s cn70xxp1;
	struct cvmx_sli_scratch_1_s cn73xx;
	struct cvmx_sli_scratch_1_s cn78xx;
	struct cvmx_sli_scratch_1_s cn78xxp1;
	struct cvmx_sli_scratch_1_s cnf71xx;
	struct cvmx_sli_scratch_1_s cnf75xx;
};

typedef union cvmx_sli_scratch_1 cvmx_sli_scratch_1_t;

/**
 * cvmx_sli_scratch_2
 *
 * This registers is a general purpose 64-bit scratch register for software use.
 *
 */
union cvmx_sli_scratch_2 {
	u64 u64;
	struct cvmx_sli_scratch_2_s {
		u64 data : 64;
	} s;
	struct cvmx_sli_scratch_2_s cn61xx;
	struct cvmx_sli_scratch_2_s cn63xx;
	struct cvmx_sli_scratch_2_s cn63xxp1;
	struct cvmx_sli_scratch_2_s cn66xx;
	struct cvmx_sli_scratch_2_s cn68xx;
	struct cvmx_sli_scratch_2_s cn68xxp1;
	struct cvmx_sli_scratch_2_s cn70xx;
	struct cvmx_sli_scratch_2_s cn70xxp1;
	struct cvmx_sli_scratch_2_s cn73xx;
	struct cvmx_sli_scratch_2_s cn78xx;
	struct cvmx_sli_scratch_2_s cn78xxp1;
	struct cvmx_sli_scratch_2_s cnf71xx;
	struct cvmx_sli_scratch_2_s cnf75xx;
};

typedef union cvmx_sli_scratch_2 cvmx_sli_scratch_2_t;

/**
 * cvmx_sli_state1
 *
 * This register contains state machines in SLI and is for debug.
 *
 */
union cvmx_sli_state1 {
	u64 u64;
	struct cvmx_sli_state1_s {
		u64 cpl1 : 12;
		u64 cpl0 : 12;
		u64 arb : 1;
		u64 csr : 39;
	} s;
	struct cvmx_sli_state1_s cn61xx;
	struct cvmx_sli_state1_s cn63xx;
	struct cvmx_sli_state1_s cn63xxp1;
	struct cvmx_sli_state1_s cn66xx;
	struct cvmx_sli_state1_s cn68xx;
	struct cvmx_sli_state1_s cn68xxp1;
	struct cvmx_sli_state1_s cn70xx;
	struct cvmx_sli_state1_s cn70xxp1;
	struct cvmx_sli_state1_s cn73xx;
	struct cvmx_sli_state1_s cn78xx;
	struct cvmx_sli_state1_s cn78xxp1;
	struct cvmx_sli_state1_s cnf71xx;
	struct cvmx_sli_state1_s cnf75xx;
};

typedef union cvmx_sli_state1 cvmx_sli_state1_t;

/**
 * cvmx_sli_state2
 *
 * This register contains state machines in SLI and is for debug.
 *
 */
union cvmx_sli_state2 {
	u64 u64;
	struct cvmx_sli_state2_s {
		u64 reserved_0_63 : 64;
	} s;
	struct cvmx_sli_state2_cn61xx {
		u64 reserved_56_63 : 8;
		u64 nnp1 : 8;
		u64 reserved_47_47 : 1;
		u64 rac : 1;
		u64 csm1 : 15;
		u64 csm0 : 15;
		u64 nnp0 : 8;
		u64 nnd : 8;
	} cn61xx;
	struct cvmx_sli_state2_cn61xx cn63xx;
	struct cvmx_sli_state2_cn61xx cn63xxp1;
	struct cvmx_sli_state2_cn61xx cn66xx;
	struct cvmx_sli_state2_cn61xx cn68xx;
	struct cvmx_sli_state2_cn61xx cn68xxp1;
	struct cvmx_sli_state2_cn61xx cn70xx;
	struct cvmx_sli_state2_cn61xx cn70xxp1;
	struct cvmx_sli_state2_cn73xx {
		u64 reserved_57_63 : 7;
		u64 nnp1 : 8;
		u64 reserved_48_48 : 1;
		u64 rac : 1;
		u64 csm1 : 15;
		u64 csm0 : 15;
		u64 nnp0 : 8;
		u64 nnd : 9;
	} cn73xx;
	struct cvmx_sli_state2_cn73xx cn78xx;
	struct cvmx_sli_state2_cn73xx cn78xxp1;
	struct cvmx_sli_state2_cn61xx cnf71xx;
	struct cvmx_sli_state2_cn73xx cnf75xx;
};

typedef union cvmx_sli_state2 cvmx_sli_state2_t;

/**
 * cvmx_sli_state3
 *
 * This register contains state machines in SLI and is for debug.
 *
 */
union cvmx_sli_state3 {
	u64 u64;
	struct cvmx_sli_state3_s {
		u64 reserved_0_63 : 64;
	} s;
	struct cvmx_sli_state3_cn61xx {
		u64 reserved_56_63 : 8;
		u64 psm1 : 15;
		u64 psm0 : 15;
		u64 nsm1 : 13;
		u64 nsm0 : 13;
	} cn61xx;
	struct cvmx_sli_state3_cn61xx cn63xx;
	struct cvmx_sli_state3_cn61xx cn63xxp1;
	struct cvmx_sli_state3_cn61xx cn66xx;
	struct cvmx_sli_state3_cn61xx cn68xx;
	struct cvmx_sli_state3_cn61xx cn68xxp1;
	struct cvmx_sli_state3_cn61xx cn70xx;
	struct cvmx_sli_state3_cn61xx cn70xxp1;
	struct cvmx_sli_state3_cn73xx {
		u64 reserved_60_63 : 4;
		u64 psm1 : 15;
		u64 psm0 : 15;
		u64 nsm1 : 15;
		u64 nsm0 : 15;
	} cn73xx;
	struct cvmx_sli_state3_cn73xx cn78xx;
	struct cvmx_sli_state3_cn73xx cn78xxp1;
	struct cvmx_sli_state3_cn61xx cnf71xx;
	struct cvmx_sli_state3_cn73xx cnf75xx;
};

typedef union cvmx_sli_state3 cvmx_sli_state3_t;

/**
 * cvmx_sli_tx_pipe
 *
 * SLI_TX_PIPE = SLI Packet TX Pipe
 *
 * Contains the starting pipe number and number of pipes used by the SLI packet Output.
 * If a packet is recevied from PKO with an out of range PIPE number, the following occurs:
 * - SLI_INT_SUM[PIPE_ERR] is set.
 * - the out of range pipe value is used for returning credits to the PKO.
 * - the PCIe packet engine will treat the PIPE value to be equal to [BASE].
 */
union cvmx_sli_tx_pipe {
	u64 u64;
	struct cvmx_sli_tx_pipe_s {
		u64 reserved_24_63 : 40;
		u64 nump : 8;
		u64 reserved_7_15 : 9;
		u64 base : 7;
	} s;
	struct cvmx_sli_tx_pipe_s cn68xx;
	struct cvmx_sli_tx_pipe_s cn68xxp1;
};

typedef union cvmx_sli_tx_pipe cvmx_sli_tx_pipe_t;

/**
 * cvmx_sli_win_rd_addr
 *
 * When the LSB of this register is written, the address in this register will be read. The data
 * returned from this read operation is placed in the WIN_RD_DATA register. This register should
 * NOT
 * be used to read SLI_* registers.
 */
union cvmx_sli_win_rd_addr {
	u64 u64;
	struct cvmx_sli_win_rd_addr_s {
		u64 reserved_51_63 : 13;
		u64 ld_cmd : 2;
		u64 iobit : 1;
		u64 rd_addr : 48;
	} s;
	struct cvmx_sli_win_rd_addr_s cn61xx;
	struct cvmx_sli_win_rd_addr_s cn63xx;
	struct cvmx_sli_win_rd_addr_s cn63xxp1;
	struct cvmx_sli_win_rd_addr_s cn66xx;
	struct cvmx_sli_win_rd_addr_s cn68xx;
	struct cvmx_sli_win_rd_addr_s cn68xxp1;
	struct cvmx_sli_win_rd_addr_s cn70xx;
	struct cvmx_sli_win_rd_addr_s cn70xxp1;
	struct cvmx_sli_win_rd_addr_s cn73xx;
	struct cvmx_sli_win_rd_addr_s cn78xx;
	struct cvmx_sli_win_rd_addr_s cn78xxp1;
	struct cvmx_sli_win_rd_addr_s cnf71xx;
	struct cvmx_sli_win_rd_addr_s cnf75xx;
};

typedef union cvmx_sli_win_rd_addr cvmx_sli_win_rd_addr_t;

/**
 * cvmx_sli_win_rd_data
 *
 * This register holds the data returned when a read operation is started by the writing of the
 * SLI_WIN_RD_ADDR register.
 */
union cvmx_sli_win_rd_data {
	u64 u64;
	struct cvmx_sli_win_rd_data_s {
		u64 rd_data : 64;
	} s;
	struct cvmx_sli_win_rd_data_s cn61xx;
	struct cvmx_sli_win_rd_data_s cn63xx;
	struct cvmx_sli_win_rd_data_s cn63xxp1;
	struct cvmx_sli_win_rd_data_s cn66xx;
	struct cvmx_sli_win_rd_data_s cn68xx;
	struct cvmx_sli_win_rd_data_s cn68xxp1;
	struct cvmx_sli_win_rd_data_s cn70xx;
	struct cvmx_sli_win_rd_data_s cn70xxp1;
	struct cvmx_sli_win_rd_data_s cn73xx;
	struct cvmx_sli_win_rd_data_s cn78xx;
	struct cvmx_sli_win_rd_data_s cn78xxp1;
	struct cvmx_sli_win_rd_data_s cnf71xx;
	struct cvmx_sli_win_rd_data_s cnf75xx;
};

typedef union cvmx_sli_win_rd_data cvmx_sli_win_rd_data_t;

/**
 * cvmx_sli_win_wr_addr
 *
 * This register contains the address to be written to when a write operation is started by
 * writing the SLI_WIN_WR_DATA register.
 *
 * This register should NOT be used to write SLI_* registers.
 */
union cvmx_sli_win_wr_addr {
	u64 u64;
	struct cvmx_sli_win_wr_addr_s {
		u64 reserved_49_63 : 15;
		u64 iobit : 1;
		u64 wr_addr : 45;
		u64 reserved_0_2 : 3;
	} s;
	struct cvmx_sli_win_wr_addr_s cn61xx;
	struct cvmx_sli_win_wr_addr_s cn63xx;
	struct cvmx_sli_win_wr_addr_s cn63xxp1;
	struct cvmx_sli_win_wr_addr_s cn66xx;
	struct cvmx_sli_win_wr_addr_s cn68xx;
	struct cvmx_sli_win_wr_addr_s cn68xxp1;
	struct cvmx_sli_win_wr_addr_s cn70xx;
	struct cvmx_sli_win_wr_addr_s cn70xxp1;
	struct cvmx_sli_win_wr_addr_s cn73xx;
	struct cvmx_sli_win_wr_addr_s cn78xx;
	struct cvmx_sli_win_wr_addr_s cn78xxp1;
	struct cvmx_sli_win_wr_addr_s cnf71xx;
	struct cvmx_sli_win_wr_addr_s cnf75xx;
};

typedef union cvmx_sli_win_wr_addr cvmx_sli_win_wr_addr_t;

/**
 * cvmx_sli_win_wr_data
 *
 * This register contains the data to write to the address located in the SLI_WIN_WR_ADDR
 * register. Writing the least-significant byte of this register causes a write operation to take
 * place.
 */
union cvmx_sli_win_wr_data {
	u64 u64;
	struct cvmx_sli_win_wr_data_s {
		u64 wr_data : 64;
	} s;
	struct cvmx_sli_win_wr_data_s cn61xx;
	struct cvmx_sli_win_wr_data_s cn63xx;
	struct cvmx_sli_win_wr_data_s cn63xxp1;
	struct cvmx_sli_win_wr_data_s cn66xx;
	struct cvmx_sli_win_wr_data_s cn68xx;
	struct cvmx_sli_win_wr_data_s cn68xxp1;
	struct cvmx_sli_win_wr_data_s cn70xx;
	struct cvmx_sli_win_wr_data_s cn70xxp1;
	struct cvmx_sli_win_wr_data_s cn73xx;
	struct cvmx_sli_win_wr_data_s cn78xx;
	struct cvmx_sli_win_wr_data_s cn78xxp1;
	struct cvmx_sli_win_wr_data_s cnf71xx;
	struct cvmx_sli_win_wr_data_s cnf75xx;
};

typedef union cvmx_sli_win_wr_data cvmx_sli_win_wr_data_t;

/**
 * cvmx_sli_win_wr_mask
 *
 * This register contains the mask for the data in the SLI_WIN_WR_DATA register.
 *
 */
union cvmx_sli_win_wr_mask {
	u64 u64;
	struct cvmx_sli_win_wr_mask_s {
		u64 reserved_8_63 : 56;
		u64 wr_mask : 8;
	} s;
	struct cvmx_sli_win_wr_mask_s cn61xx;
	struct cvmx_sli_win_wr_mask_s cn63xx;
	struct cvmx_sli_win_wr_mask_s cn63xxp1;
	struct cvmx_sli_win_wr_mask_s cn66xx;
	struct cvmx_sli_win_wr_mask_s cn68xx;
	struct cvmx_sli_win_wr_mask_s cn68xxp1;
	struct cvmx_sli_win_wr_mask_s cn70xx;
	struct cvmx_sli_win_wr_mask_s cn70xxp1;
	struct cvmx_sli_win_wr_mask_s cn73xx;
	struct cvmx_sli_win_wr_mask_s cn78xx;
	struct cvmx_sli_win_wr_mask_s cn78xxp1;
	struct cvmx_sli_win_wr_mask_s cnf71xx;
	struct cvmx_sli_win_wr_mask_s cnf75xx;
};

typedef union cvmx_sli_win_wr_mask cvmx_sli_win_wr_mask_t;

/**
 * cvmx_sli_window_ctl
 *
 * Access to register space on the IOI (caused by window read/write operations) waits for a
 * period of time specified by this register before timing out.
 */
union cvmx_sli_window_ctl {
	u64 u64;
	struct cvmx_sli_window_ctl_s {
		u64 ocx_time : 32;
		u64 time : 32;
	} s;
	struct cvmx_sli_window_ctl_cn61xx {
		u64 reserved_32_63 : 32;
		u64 time : 32;
	} cn61xx;
	struct cvmx_sli_window_ctl_cn61xx cn63xx;
	struct cvmx_sli_window_ctl_cn61xx cn63xxp1;
	struct cvmx_sli_window_ctl_cn61xx cn66xx;
	struct cvmx_sli_window_ctl_cn61xx cn68xx;
	struct cvmx_sli_window_ctl_cn61xx cn68xxp1;
	struct cvmx_sli_window_ctl_cn61xx cn70xx;
	struct cvmx_sli_window_ctl_cn61xx cn70xxp1;
	struct cvmx_sli_window_ctl_s cn73xx;
	struct cvmx_sli_window_ctl_s cn78xx;
	struct cvmx_sli_window_ctl_s cn78xxp1;
	struct cvmx_sli_window_ctl_cn61xx cnf71xx;
	struct cvmx_sli_window_ctl_s cnf75xx;
};

typedef union cvmx_sli_window_ctl cvmx_sli_window_ctl_t;

#endif
