# Trilinos
![Trilinos Logo](https://trilinos.github.io/images/trilinos.jpg)

[Website](https://trilinos.github.io) |
[Documentation](https://trilinos.github.io/documentation.html) |
[Mailing List](https://trilinos.github.io/mail_lists.html) |
[Packages](http://trilinos.github.io/packages.html)


[![OpenSSF Scorecard](https://api.securityscorecards.dev/projects/github.com/trilinos/Trilinos/badge)](https://securityscorecards.dev/viewer/?uri=github.com/trilinos/Trilinos)
[![OpenSSF Best Practices](https://www.bestpractices.dev/projects/9452/badge)](https://www.bestpractices.dev/projects/9452)
[![CodeFactor](https://www.codefactor.io/repository/github/trilinos/trilinos/badge)](https://www.codefactor.io/repository/github/trilinos/trilinos)
![GitHub contributors](https://img.shields.io/github/contributors/trilinos/Trilinos)
![GitHub commit activity](https://img.shields.io/github/commit-activity/w/trilinos/Trilinos)


The Trilinos Project is an effort to develop algorithms and enabling
technologies within an object-oriented software framework for the solution of
large-scale, complex multi-physics engineering and scientific problems. A
unique design feature of Trilinos is its focus on packages.


### Documentation

- [Getting Started with Trilinos](https://trilinos.github.io/getting_started.html)

- [General Documentation](https://trilinos.github.io/documentation.html)

- [Quick configure, build and install hints for Trilinos](INSTALL.rst)

- [Trilinos Configure, Build, Test, and Install Reference Guide](https://trilinos.org/docs/files/TrilinosBuildReference.html)

- To ensure appropriate parties receive your issues, please direct issues by mentioning the
  [Trilinos package owners](https://github.com/trilinos/Trilinos/wiki/Trilinos-Package-Owners).
  External users may not mention Github teams, but may mention individual owners instead.

- For help with a particular package, see the website and accompanying
  documentation for that package. Links to these can be found down the
  right side of any page on the website and at [the package website](https://trilinos.github.io/packages.html).

- Sample build scripts for various platforms can be found in the
  sampleScripts directory.  Please note that these sample scripts are
  only a starting point for you to develop a script that works for
  your own platform.

- If you have questions, please submit an issue on the Trilinos repo 
  [GitHub Issues page](https://github.com/trilinos/Trilinos/issues).


### License

Trilinos is licensed on a per-package basis. Most packages are now
under a BSD license, some are published under the (L)GPL. Details
can be taken from the documentation of each package.  See COPYRIGHT,
LICENSE, https://trilinos.github.io/license.html and individual package,
directory and/or file headers for additional information.

### Contributing

We appreciate your willingness to contribute to the Trilinos project.  Please
familiarize yourself with our [contributing
guidelines](https://github.com/trilinos/Trilinos/blob/master/CONTRIBUTING.md).
